/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.misc.PsiElementSetSpinAllocator;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.impl.reference.AntElementCompletionWrapper;
import com.intellij.lang.ant.psi.impl.reference.AntGenericReference;
import com.intellij.lang.ant.quickfix.AntChangeContextFix;
import com.intellij.lang.ant.quickfix.AntCreatePropertyFix;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.StringSetSpinAllocator;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntPropertyReference
extends AntGenericReference {
    public AntPropertyReference(AntElement antElement, String str, TextRange textRange, XmlAttribute attribute) {
        super(antElement, str, textRange, attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        AntElement element = this.getElement();
        String oldName = this.getCanonicalText();
        XmlAttribute attr = this.getAttribute();
        XmlAttributeValue attrValue = attr.getValueElement();
        if (attrValue != null) {
            int valueStartOffset = attrValue.getTextRange().getStartOffset() - element.getTextRange().getStartOffset() + 1;
            String value = attr.getValue();
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                AntFile antFile = element.getAntFile();
                AntProperty resolved = antFile != null ? antFile.getProperty(oldName) : null;
                String prefix = resolved != null ? resolved.getPrefix() : null;
                int startOffset = this.getRangeInElement().getStartOffset();
                int endOffset = this.getRangeInElement().getEndOffset();
                if (valueStartOffset < startOffset) {
                    builder.append(value.substring(0, startOffset - valueStartOffset));
                }
                if (prefix != null) {
                    builder.append(prefix).append(".");
                }
                builder.append(newElementName);
                if (endOffset < valueStartOffset + value.length()) {
                    builder.append(value.substring(endOffset - valueStartOffset));
                }
                attr.setValue(builder.toString());
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        return element;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/AntPropertyReference.bindToElement must not be null");
        }
        return this.handleElementRename(((PsiNamedElement)element).getName());
    }

    @Override
    public PsiElement resolveInner() {
        AntElement elem = this.getElement();
        AntFile contextFile = AntConfigurationBase.getInstance(elem.getProject()).getEffectiveContextFile(elem.getAntFile());
        if (contextFile == null) {
            return null;
        }
        String text = this.getCanonicalText();
        AntProperty resolved = contextFile.getProperty(text);
        if (resolved != null) {
            String propName = AntPropertyReference.cutPrefix(text, resolved.getPrefix());
            PropertiesFile propFile = resolved.getPropertiesFile();
            if (propFile != null) {
                return propFile.findPropertyByKey(propName);
            }
            return resolved.getFormatElement(propName);
        }
        return null;
    }

    private static String cutPrefix(String text, String prefix) {
        if (prefix != null && text.startsWith(prefix) && prefix.length() < text.length() && text.charAt(prefix.length()) == '.') {
            return text.substring(prefix.length() + 1);
        }
        return text;
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("unknown.property", this.getCanonicalText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object[] getVariants() {
        AntElement currentElement = this.getElement();
        Set<PsiElement> variants = PsiElementSetSpinAllocator.alloc();
        try {
            AntFile antFile = currentElement.getAntFile();
            Project project = currentElement.getProject();
            for (AntProperty property : antFile.getProperties()) {
                String[] names;
                if (currentElement == property || (names = property.getNames()) == null) continue;
                for (String name : names) {
                    variants.add(new AntElementCompletionWrapper((AntElement)property.getParent(), name, project, AntElementRole.PROPERTY_ROLE));
                }
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntPropertyReference.getVariants must not return null");
            }
            return objectArray;
        }
        finally {
            PsiElementSetSpinAllocator.dispose(variants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public IntentionAction[] getFixes() {
        IntentionAction[] intentionActionArray;
        String name = this.getCanonicalRepresentationText();
        if (name == null || name.length() == 0) {
            intentionActionArray = IntentionAction.EMPTY_ARRAY;
            if (IntentionAction.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntPropertyReference.getFixes must not return null");
            return intentionActionArray;
        }
        ArrayList<BaseIntentionAction> result = new ArrayList<BaseIntentionAction>();
        AntProject project = this.getElement().getAntProject();
        result.add(new AntCreatePropertyFix(this));
        Set files = StringSetSpinAllocator.alloc();
        try {
            for (PsiElement child : project.getChildren()) {
                String fileName;
                PropertiesFile propFile;
                if (!(child instanceof AntProperty) || (propFile = ((AntProperty)child).getPropertiesFile()) == null || files.contains(fileName = propFile.getName())) continue;
                files.add(fileName);
                result.add(new AntCreatePropertyFix(this, propFile));
            }
        }
        finally {
            StringSetSpinAllocator.dispose((Set)files);
        }
        result.add(new AntChangeContextFix());
        intentionActionArray = result.toArray(new IntentionAction[result.size()]);
        if (intentionActionArray != null) return intentionActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntPropertyReference.getFixes must not return null");
    }
}

