/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntScriptDef;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntAllTasksContainerImpl;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.lang.ant.psi.introspection.impl.AntTypeDefinitionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntScriptDefImpl
extends AntTaskImpl
implements AntScriptDef {
    @NonNls
    public static final String ANT_SCRIPTDEF_NAME = "AntScriptDef";
    private AntTypeDefinitionImpl myScriptDefinition;

    public AntScriptDefImpl(AntStructuredElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
        this.invalidateScriptDefinition();
    }

    @Override
    public String toString() {
        return AntScriptDefImpl.createScriptClassName(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createScriptClassName(String macroName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(ANT_SCRIPTDEF_NAME);
            builder.append("[");
            builder.append(macroName);
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public AntElementRole getRole() {
        return AntElementRole.SCRIPTDEF_ROLE;
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntScriptDefImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntScriptDef(this);
    }

    @Override
    public AntTypeDefinition getScriptDefinition() {
        return this.myScriptDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            AntFile file = this.getAntFile();
            this.clearClassesCache();
            file.clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClassesCache() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myScriptDefinition != null) {
                AntFile file = this.getAntFile();
                AntAllTasksContainerImpl sequential = (AntAllTasksContainerImpl)PsiTreeUtil.getChildOfType((PsiElement)this, AntAllTasksContainerImpl.class);
                if (sequential != null) {
                    sequential.unregisterCustomType(this.myScriptDefinition);
                }
                for (AntTypeId id : this.myScriptDefinition.getNestedElements()) {
                    AntTypeDefinition nestedDef = file.getBaseTypeDefinition(this.myScriptDefinition.getNestedClassName(id));
                    if (nestedDef == null) continue;
                    file.unregisterCustomType(nestedDef);
                    if (sequential == null) continue;
                    sequential.unregisterCustomType(nestedDef);
                }
                AntProject parent = this.getAntProject();
                if (parent != null) {
                    parent.unregisterCustomType(this.myScriptDefinition);
                }
                this.myScriptDefinition = null;
            }
        }
    }

    private void invalidateScriptDefinition() {
        AntAllTasksContainerImpl sequential;
        if (!this.hasNameElement()) {
            this.myScriptDefinition = null;
            return;
        }
        AntFile file = this.getAntFile();
        if (file == null) {
            return;
        }
        String thisClassName = AntScriptDefImpl.createScriptClassName(this.getName());
        this.myScriptDefinition = (AntTypeDefinitionImpl)file.getBaseTypeDefinition(thisClassName);
        Map<Object, Object> attributes = this.myScriptDefinition == null ? new HashMap() : this.myScriptDefinition.getAttributesMap();
        attributes.clear();
        HashMap<AntTypeId, String> nestedElements = this.myScriptDefinition == null ? new HashMap() : this.myScriptDefinition.getNestedElementsMap();
        for (AntElement child : this.getChildren()) {
            AntTypeDefinitionImpl targetDef;
            AntStructuredElement se;
            String name;
            if (!(child instanceof AntStructuredElement) || (name = (se = (AntStructuredElement)child).getName()) == null) continue;
            XmlTag sourceElement = se.getSourceElement();
            String tagName = sourceElement.getName();
            if (tagName.equals("attribute")) {
                attributes.put(name.toLowerCase(Locale.US), (Object)AntAttributeType.STRING);
                continue;
            }
            if (!tagName.equals("element")) continue;
            String classNameAttrib = sourceElement.getAttributeValue("classname");
            String elementClassName = classNameAttrib != null ? classNameAttrib : thisClassName + '$' + name;
            AntTypeDefinitionImpl nestedDef = (AntTypeDefinitionImpl)file.getBaseTypeDefinition(elementClassName);
            if (nestedDef == null && (targetDef = (AntTypeDefinitionImpl)file.getTargetDefinition()) != null) {
                nestedDef = new AntTypeDefinitionImpl(targetDef);
            }
            if (nestedDef == null) continue;
            String typeAttrib = sourceElement.getAttributeValue("type");
            String typeName = typeAttrib != null ? typeAttrib : name;
            AntTypeId typeId = new AntTypeId(typeName);
            nestedDef.setTypeId(typeId);
            nestedDef.setClassName(elementClassName);
            nestedDef.setDefiningElement(child);
            file.registerCustomType(nestedDef);
            nestedElements.put(typeId, nestedDef.getClassName());
        }
        AntTypeId definedTypeId = new AntTypeId(this.getName());
        if (this.myScriptDefinition == null) {
            this.myScriptDefinition = new AntTypeDefinitionImpl(definedTypeId, thisClassName, true, false, attributes, nestedElements, this);
        } else {
            this.myScriptDefinition.setTypeId(definedTypeId);
            this.myScriptDefinition.setClassName(thisClassName);
            this.myScriptDefinition.setIsTask(true);
            this.myScriptDefinition.setDefiningElement(this);
        }
        AntProject parent = this.getAntProject();
        if (parent != null) {
            parent.registerCustomType(this.myScriptDefinition);
        }
        if ((sequential = (AntAllTasksContainerImpl)PsiTreeUtil.getChildOfType((PsiElement)this, AntAllTasksContainerImpl.class)) != null) {
            sequential.registerCustomType(this.myScriptDefinition);
            for (AntTypeId id : this.myScriptDefinition.getNestedElements()) {
                sequential.registerCustomType(file.getBaseTypeDefinition(this.myScriptDefinition.getNestedClassName(id)));
            }
        }
    }
}

