/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntMacroDef;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntAllTasksContainerImpl;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.lang.ant.psi.introspection.impl.AntTypeDefinitionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntMacroDefImpl
extends AntTaskImpl
implements AntMacroDef {
    @NonNls
    public static final String ANT_MACRODEF_NAME = "AntMacroDef";
    private AntTypeDefinitionImpl myMacroDefinition;

    public AntMacroDefImpl(AntStructuredElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
        this.invalidateMacroDefinition();
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntMacroDefImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntMacroDef(this);
    }

    @Override
    public String toString() {
        return AntMacroDefImpl.createMacroClassName(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createMacroClassName(String macroName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(ANT_MACRODEF_NAME);
            builder.append("[");
            builder.append(macroName);
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public AntElementRole getRole() {
        return AntElementRole.MACRODEF_ROLE;
    }

    @Override
    public AntTypeDefinition getMacroDefinition() {
        return this.myMacroDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.clearClassesCache();
            this.getAntFile().clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClassesCache() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myMacroDefinition != null) {
                AntFile file = this.getAntFile();
                for (AntTypeId id : this.myMacroDefinition.getNestedElements()) {
                    AntTypeDefinition nestedDef = file.getBaseTypeDefinition(this.myMacroDefinition.getNestedClassName(id));
                    if (nestedDef == null) continue;
                    file.unregisterCustomType(nestedDef);
                }
                AntProject parent = this.getAntProject();
                if (parent != null) {
                    parent.unregisterCustomType(this.myMacroDefinition);
                }
                this.myMacroDefinition = null;
            }
        }
    }

    private void invalidateMacroDefinition() {
        AntAllTasksContainerImpl sequential;
        if (!this.hasNameElement()) {
            this.myMacroDefinition = null;
            return;
        }
        AntFile file = this.getAntFile();
        if (file == null) {
            return;
        }
        String thisClassName = AntMacroDefImpl.createMacroClassName(this.getName());
        this.myMacroDefinition = (AntTypeDefinitionImpl)file.getBaseTypeDefinition(thisClassName);
        Map<Object, Object> attributes = this.myMacroDefinition == null ? new HashMap() : this.myMacroDefinition.getAttributesMap();
        attributes.clear();
        HashMap<AntTypeId, String> nestedElements = this.myMacroDefinition == null ? new HashMap() : this.myMacroDefinition.getNestedElementsMap();
        for (AntElement child : this.getChildren()) {
            AntTypeDefinitionImpl targetDef;
            AntStructuredElement se;
            String name;
            if (!(child instanceof AntStructuredElement) || (name = (se = (AntStructuredElement)child).getName()) == null) continue;
            String tagName = se.getSourceElement().getName();
            if (tagName.equals("attribute")) {
                attributes.put(name.toLowerCase(Locale.US), (Object)AntAttributeType.STRING);
                continue;
            }
            if (!tagName.equals("element")) continue;
            String elementClassName = thisClassName + '$' + name;
            AntTypeDefinitionImpl nestedDef = (AntTypeDefinitionImpl)file.getBaseTypeDefinition(elementClassName);
            if (nestedDef == null && (targetDef = (AntTypeDefinitionImpl)file.getTargetDefinition()) != null) {
                nestedDef = new AntTypeDefinitionImpl(targetDef);
            }
            if (nestedDef == null) continue;
            AntTypeId typeId = new AntTypeId(name);
            nestedDef.setTypeId(typeId);
            nestedDef.setClassName(elementClassName);
            nestedDef.setIsTask(false);
            nestedDef.setDefiningElement(child);
            file.registerCustomType(nestedDef);
            nestedElements.put(typeId, nestedDef.getClassName());
        }
        AntTypeId definedTypeId = new AntTypeId(this.getName());
        if (this.myMacroDefinition == null) {
            this.myMacroDefinition = new AntTypeDefinitionImpl(definedTypeId, thisClassName, true, false, attributes, nestedElements, this);
        } else {
            this.myMacroDefinition.setTypeId(definedTypeId);
            this.myMacroDefinition.setClassName(thisClassName);
            this.myMacroDefinition.setIsTask(true);
            this.myMacroDefinition.setDefiningElement(this);
        }
        AntProject parent = this.getAntProject();
        if (parent != null) {
            parent.registerCustomType(this.myMacroDefinition);
        }
        if ((sequential = (AntAllTasksContainerImpl)PsiTreeUtil.getChildOfType((PsiElement)this, AntAllTasksContainerImpl.class)) != null) {
            sequential.registerCustomType(this.myMacroDefinition);
            for (AntTypeId id : this.myMacroDefinition.getNestedElements()) {
                sequential.registerCustomType(file.getBaseTypeDefinition(this.myMacroDefinition.getNestedClassName(id)));
            }
        }
    }
}

