/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Alarm;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.IntrospectionHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class AntIntrospector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.psi.impl.AntIntrospector");
    private final Object myHelper;
    private static final HashMap<Class, Object> ourCache = new HashMap();
    private static final Object ourNullObject = new Object();
    private static final Alarm ourCacheCleaner = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private static final int CACHE_CLEAN_TIMEOUT = 10000;

    public AntIntrospector(Class aClass) {
        this.myHelper = AntIntrospector.getHelper(aClass);
    }

    @Nullable
    public static AntIntrospector getInstance(Class c) {
        AntIntrospector antIntrospector = new AntIntrospector(c);
        return antIntrospector.myHelper == null ? null : antIntrospector;
    }

    private <T> T invokeMethod(@NonNls String methodName, boolean ignoreErrors, Object ... params) {
        block9: {
            Class<?> helperClass = this.myHelper.getClass();
            Class[] types = new Class[params.length];
            try {
                for (int idx = 0; idx < params.length; ++idx) {
                    types[idx] = params[idx].getClass();
                }
                Method method = helperClass.getMethod(methodName, types);
                return (T)method.invoke(this.myHelper, params);
            }
            catch (IllegalAccessException e) {
                if (!ignoreErrors) {
                    LOG.error((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                if (!ignoreErrors) {
                    LOG.error((Throwable)e);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (ignoreErrors) break block9;
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public Set<String> getExtensionPointTypes() {
        List methods = (List)this.invokeMethod("getExtensionPoints", true, new Object[0]);
        if (methods == null || methods.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        for (Method method : methods) {
            Class<?>[] paramTypes;
            for (Class<?> paramType : paramTypes = method.getParameterTypes()) {
                types.add(paramType.getName());
            }
        }
        return types;
    }

    public Enumeration getNestedElements() {
        return (Enumeration)this.invokeMethod("getNestedElements", false, new Object[0]);
    }

    @Nullable
    public Class getElementType(String name) {
        try {
            return (Class)this.invokeMethod("getElementType", false, name);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public Enumeration getAttributes() {
        return (Enumeration)this.invokeMethod("getAttributes", false, new Object[0]);
    }

    @Nullable
    public Class getAttributeType(String attr) {
        try {
            return (Class)this.invokeMethod("getAttributeType", false, attr);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Object getHelper(Class aClass) {
        ClassLoader loader = aClass.getClassLoader();
        Object result = null;
        HashMap<Class, Object> hashMap = ourCache;
        synchronized (hashMap) {
            result = ourCache.get(aClass);
        }
        if (result == null) {
            result = ourNullObject;
            Class<IntrospectionHelper> helperClass = null;
            try {
                helperClass = loader != null ? loader.loadClass(IntrospectionHelper.class.getName()) : IntrospectionHelper.class;
                Method getHelperMethod = helperClass.getMethod("getHelper", Class.class);
                result = getHelperMethod.invoke(null, aClass);
            }
            catch (ClassNotFoundException e) {
                LOG.info((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.info((Throwable)e);
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
            HashMap<Class, Object> hashMap2 = ourCache;
            synchronized (hashMap2) {
                if (helperClass != null) {
                    AntIntrospector.clearAntStaticCache(helperClass);
                }
                ourCache.put(aClass, result);
            }
        }
        AntIntrospector.scheduleCacheCleaning();
        return result == ourNullObject ? null : result;
    }

    private static void clearAntStaticCache(Class helperClass) {
        try {
            Method method = helperClass.getDeclaredMethod("clearCache", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            try {
                Field helpersField = helperClass.getDeclaredField("helpers");
                Map helpersCollection = (Map)helpersField.get(null);
                helpersCollection.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void scheduleCacheCleaning() {
        ourCacheCleaner.cancelAllRequests();
        ourCacheCleaner.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = ourCache;
                synchronized (hashMap) {
                    ourCache.clear();
                }
            }
        }, 10000);
    }
}

