/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntImport;
import com.intellij.lang.ant.psi.impl.AntStructuredElementImpl;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntImportImpl
extends AntTaskImpl
implements AntImport {
    public AntImportImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntImportImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntImport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntImport[");
            builder.append(this.getSourceElement().getAttributeValue("file"));
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    @NotNull
    public List<String> getFileReferenceAttributes() {
        List<String> list = Collections.singletonList("file");
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntImportImpl.getFileReferenceAttributes must not return null");
        }
        return list;
    }

    @Override
    @Nullable
    public String getFileName() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue("file"));
    }

    @Override
    public AntFile getImportedFile() {
        return AntImportImpl.getImportedFile(this.getFileName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.getAntFile().clearCaches();
        }
    }

    @Nullable
    static AntFile getImportedFile(String name, AntStructuredElementImpl element) {
        if (name == null) {
            return null;
        }
        PsiFile psiFile = element.findFileByName(name);
        if (psiFile != null) {
            if (psiFile instanceof XmlFile) {
                VirtualFile file = psiFile.getVirtualFile();
                if (file != null) {
                    AntSupport.markFileAsAntFile(file, psiFile.getViewProvider(), true);
                }
                return AntSupport.getAntFile(psiFile);
            }
            if (psiFile instanceof AntFile) {
                return (AntFile)psiFile;
            }
        }
        return null;
    }
}

