/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.ide.macro.MacroManager;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.impl.AllJarsUnderDirEntry;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.CompositePropertyContainer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.StorageProperty;
import com.intellij.util.config.ValueProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GlobalAntConfiguration
implements ApplicationComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.AntGlobalConfiguration");
    public static final StorageProperty FILTERS_TABLE_LAYOUT = new StorageProperty("filtersTableLayout");
    public static final StorageProperty PROPERTIES_TABLE_LAYOUT = new StorageProperty("propertiesTableLayout");
    static final ListProperty<AntInstallation> ANTS = ListProperty.create((String)"registeredAnts");
    private final ExternalizablePropertyContainer myProperties = new ExternalizablePropertyContainer();
    private final AntInstallation myBundledAnt;
    public static final String BUNDLED_ANT_NAME = AntBundle.message("ant.reference.bundled.ant.name", new Object[0]);
    public final Condition<AntInstallation> IS_USER_ANT = new Condition<AntInstallation>(){

        public boolean value(AntInstallation antInstallation) {
            return antInstallation != GlobalAntConfiguration.this.myBundledAnt;
        }
    };
    public static final AbstractProperty<GlobalAntConfiguration> INSTANCE = new ValueProperty("$GlobalAntConfiguration.INSTANCE", null);
    @NonNls
    public static final String ANT_FILE = "ant";
    @NonNls
    public static final String LIB_DIR = "lib";
    @NonNls
    public static final String ANT_JAR_FILE_NAME = "ant.jar";

    public GlobalAntConfiguration() {
        this.myProperties.registerProperty(FILTERS_TABLE_LAYOUT);
        this.myProperties.registerProperty(PROPERTIES_TABLE_LAYOUT);
        this.myProperties.registerProperty(ANTS, ANT_FILE, AntInstallation.EXTERNALIZER);
        INSTANCE.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)this);
        this.myProperties.rememberKey(INSTANCE);
        this.myBundledAnt = GlobalAntConfiguration.createBundledAnt();
    }

    @NotNull
    public String getComponentName() {
        if ("GlobalAntConfiguration" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/impl/GlobalAntConfiguration.getComponentName must not return null");
        }
        return "GlobalAntConfiguration";
    }

    public void initComponent() {
    }

    public static AntInstallation createBundledAnt() {
        AntInstallation bundledAnt = new AntInstallation(){

            @Override
            public AntReference getReference() {
                return AntReference.BUNDLED_ANT;
            }
        };
        AntInstallation.NAME.set(bundledAnt.getProperties(), (Object)BUNDLED_ANT_NAME);
        File antHome = PathManager.findFileInLibDirectory((String)ANT_FILE);
        AntInstallation.HOME_DIR.set(bundledAnt.getProperties(), (Object)antHome.getAbsolutePath());
        ArrayList classpath = AntInstallation.CLASS_PATH.getModifiableList(bundledAnt.getProperties());
        File antLibDir = new File(antHome, LIB_DIR);
        classpath.add(new AllJarsUnderDirEntry(antLibDir));
        bundledAnt.updateVersion(new File(antLibDir, ANT_JAR_FILE_NAME));
        return bundledAnt;
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myProperties.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myProperties.writeExternal(element);
    }

    public static GlobalAntConfiguration getInstance() {
        return (GlobalAntConfiguration)ApplicationManager.getApplication().getComponent(GlobalAntConfiguration.class);
    }

    public Map<AntReference, AntInstallation> getConfiguredAnts() {
        HashMap map = ContainerUtil.assignKeys((Iterator)ANTS.getIterator(this.getProperties()), AntInstallation.REFERENCE_TO_ANT);
        map.put((Object)AntReference.BUNDLED_ANT, (Object)this.myBundledAnt);
        return map;
    }

    public AntInstallation getBundledAnt() {
        return this.myBundledAnt;
    }

    public AbstractProperty.AbstractPropertyContainer getProperties() {
        return this.myProperties;
    }

    public AbstractProperty.AbstractPropertyContainer getProperties(Project project) {
        return new CompositePropertyContainer(new AbstractProperty.AbstractPropertyContainer[]{this.myProperties, AntConfigurationBase.getInstance(project).getProperties()});
    }

    public void addConfiguration(AntInstallation ant) {
        if (this.getConfiguredAnts().containsKey(ant.getReference())) {
            LOG.error("Duplicate name: " + ant.getName());
        }
        ANTS.getModifiableList(this.getProperties()).add(ant);
    }

    public void removeConfiguration(AntInstallation ant) {
        ANTS.getModifiableList(this.getProperties()).remove(ant);
    }

    public static Sdk findJdk(String jdkName) {
        return ProjectJdkTable.getInstance().findJdk(jdkName);
    }

    public static MacroManager getMacroManager() {
        return MacroManager.getInstance();
    }
}

