/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ForcedAntFileAttribute
extends FileAttribute {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.ForcedAntFileAttribute");
    private static final ForcedAntFileAttribute ourAttribute = new ForcedAntFileAttribute();
    private static final Key<Boolean> ourAntFileMarker = Key.create((String)"_forced_ant_attribute_");

    public ForcedAntFileAttribute() {
        super("_forced_ant_attribute_", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAntFile(VirtualFile file) {
        if (file instanceof NewVirtualFile) {
            DataInputStream is = ourAttribute.readAttribute(file);
            if (is != null) {
                boolean bl;
                try {
                    bl = is.readBoolean();
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                is.close();
                return bl;
            }
            return false;
        }
        return Boolean.TRUE.equals(file.getUserData(ourAntFileMarker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceAntFile(VirtualFile file, boolean value) {
        if (file instanceof NewVirtualFile) {
            DataOutputStream os = ourAttribute.writeAttribute(file);
            try {
                try {
                    os.writeBoolean(value);
                }
                finally {
                    os.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else {
            file.putUserData(ourAntFileMarker, (Object)value);
        }
    }
}

