/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.NotNullFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.gpp.GppClosureParameterTypeProvider;
import org.jetbrains.plugins.groovy.gpp.GppTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.resolve.DominanceAwareMethod;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GppStdLibSupport
implements NonCodeMembersProcessor {
    private static final Key<CachedValue<Map<String, List<PsiMethod>>>> CACHED_STDLIB = Key.create((String)"GppStdLib");
    private static final String[] STDLIB_CLASSES = new String[]{"groovy.util.Conversions", "groovy.util.Files", "groovy.util.Filters", "groovy.util.Iterations", "groovy.util.Mappers", "groovy.util.Sort", "groovy.util.Strings", "groovy.util.With", "groovy.util.concurrent.Atomics", "org.mbte.groovypp.runtime.ArraysMethods", "org.mbte.groovypp.runtime.DefaultGroovyPPMethods"};

    public boolean processNonCodeMembers(PsiType type, PsiScopeProcessor processor, PsiElement place, boolean forCompletion) {
        if (!(type instanceof PsiClassType)) {
            return true;
        }
        if (!GppTypeConverter.hasTypedContext(place)) {
            return true;
        }
        String className = TypeConversionUtil.erasure((PsiType)type).getCanonicalText();
        final Project project = place.getProject();
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, CACHED_STDLIB, (CachedValueProvider)new CachedValueProvider<Map<String, List<PsiMethod>>>(){

            public CachedValueProvider.Result<Map<String, List<PsiMethod>>> compute() {
                GroovyPsiManager manager = GroovyPsiManager.getInstance((Project)project);
                HashMap result = new HashMap();
                NotNullFunction<PsiMethod, PsiMethod> nonStaticConverter = new NotNullFunction<PsiMethod, PsiMethod>(){

                    @NotNull
                    public PsiMethod fun(PsiMethod method) {
                        GppGdkMethod gppGdkMethod = new GppGdkMethod(method, false);
                        if (gppGdkMethod == null) {
                            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppStdLibSupport$1$1.fun must not return null");
                        }
                        return gppGdkMethod;
                    }
                };
                for (String qname : STDLIB_CLASSES) {
                    manager.addCategoryMethods(qname, result, (NotNullFunction)nonStaticConverter);
                }
                manager.addCategoryMethods("org.mbte.groovypp.runtime.DefaultGroovyPPStaticMethods", result, (NotNullFunction)new NotNullFunction<PsiMethod, PsiMethod>(){

                    @NotNull
                    public PsiMethod fun(PsiMethod method) {
                        GppGdkMethod gppGdkMethod = new GppGdkMethod(method, true);
                        if (gppGdkMethod == null) {
                            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppStdLibSupport$1$2.fun must not return null");
                        }
                        return gppGdkMethod;
                    }
                });
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
            }
        }, false);
        List methods = (List)map.get(className);
        if (methods == null) {
            return true;
        }
        for (PsiMethod method : methods) {
            if (ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)method)) continue;
            return false;
        }
        return true;
    }

    private static class GppGdkMethod
    extends GrGdkMethodImpl
    implements DominanceAwareMethod {
        public GppGdkMethod(PsiMethod method, boolean isStatic) {
            super(method, isStatic);
        }

        public boolean isMoreConcreteThan(@NotNull PsiSubstitutor substitutor, @NotNull PsiMethod another, @NotNull PsiSubstitutor anotherSubstitutor, @NotNull GroovyPsiElement context) {
            if (substitutor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppStdLibSupport$GppGdkMethod.isMoreConcreteThan must not be null");
            }
            if (another == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppStdLibSupport$GppGdkMethod.isMoreConcreteThan must not be null");
            }
            if (anotherSubstitutor == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppStdLibSupport$GppGdkMethod.isMoreConcreteThan must not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppStdLibSupport$GppGdkMethod.isMoreConcreteThan must not be null");
            }
            if (another instanceof GrGdkMethodImpl && another.getName().equals(this.getName())) {
                PsiParameter[] plusParameters = this.getParameterList().getParameters();
                PsiParameter[] defParameters = another.getParameterList().getParameters();
                PsiType[] paramTypes = new PsiType[plusParameters.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = GppGdkMethod.eliminateOneMethodInterfaces(plusParameters[i], defParameters, i);
                }
                GrClosureSignature gdkSignature = GrClosureSignatureUtil.createSignature((PsiMethod)another, (PsiSubstitutor)anotherSubstitutor);
                if (GrClosureSignatureUtil.isSignatureApplicable((GrClosureSignature)gdkSignature, (PsiType[])paramTypes, (GroovyPsiElement)context)) {
                    return true;
                }
            }
            return false;
        }

        private static PsiType eliminateOneMethodInterfaces(PsiParameter plusParameter, PsiParameter[] gdkParameters, int i) {
            PsiType type = plusParameter.getType();
            if (i < gdkParameters.length && gdkParameters[i].getType().equalsToText("groovy.lang.Closure") && GppClosureParameterTypeProvider.findSingleAbstractMethodSignature(type) != null) {
                return gdkParameters[i].getType();
            }
            return type;
        }
    }
}

