/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.gpp.GppClassSubstitutor;
import org.jetbrains.plugins.groovy.lang.psi.GrClassSubstitutor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GppPositionManager
extends ScriptPositionManagerHelper {
    private static final String TRAIT_IMPL = "$TraitImpl";

    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        if (runtimeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppPositionManager.isAppropriateRuntimeName must not be null");
        }
        return runtimeName.endsWith(TRAIT_IMPL);
    }

    public boolean isAppropriateScriptFile(@NotNull PsiFile scriptFile) {
        if (scriptFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppPositionManager.isAppropriateScriptFile must not be null");
        }
        return false;
    }

    @NotNull
    public String getRuntimeScriptName(@NotNull String originalName, GroovyFile groovyFile) {
        if (originalName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppPositionManager.getRuntimeScriptName must not be null");
        }
        String string = originalName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppPositionManager.getRuntimeScriptName must not return null");
        }
        return string;
    }

    public PsiFile getExtraScriptIfNotFound(ReferenceType refType, @NotNull String runtimeName, Project project) {
        if (runtimeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppPositionManager.getExtraScriptIfNotFound must not be null");
        }
        PsiClass trait = JavaPsiFacade.getInstance((Project)project).findClass(StringUtil.trimEnd((String)runtimeName, (String)TRAIT_IMPL), GlobalSearchScope.allScope((Project)project));
        if (trait != null) {
            return trait.getContainingFile();
        }
        return null;
    }

    public String customizeClassName(PsiClass psiClass) {
        String qname;
        if (GrClassSubstitutor.getSubstitutedClass((PsiClass)psiClass) instanceof GppClassSubstitutor.TraitClass && (qname = psiClass.getQualifiedName()) != null) {
            return qname + TRAIT_IMPL;
        }
        return null;
    }
}

