/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.FilterCache;
import com.intellij.execution.junit2.TestProxyListener;
import com.intellij.execution.junit2.TestProxyListenersNotifier;
import com.intellij.execution.junit2.events.NewChildEvent;
import com.intellij.execution.junit2.events.StateChangedEvent;
import com.intellij.execution.junit2.events.StatisticsChanged;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.events.TestEventsConsumer;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.junit2.segments.InputConsumer;
import com.intellij.execution.junit2.states.Statistics;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.ChangingPrintable;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.ExternalOutput;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.ui.PrintableTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TestProxy
extends CompositePrintable
implements PrintableTestProxy,
InputConsumer,
ChangingPrintable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.TestProxy");
    private final TestInfo myInfo;
    private TestState myState;
    private Printer myPrinter;
    private final TestProxyListenersNotifier myNotifier;
    private Statistics myStatistics;
    private TestEventsConsumer myEventsConsumer;
    private int myPreviousMagnitude;
    private int myStateTimestamp;
    private boolean myMarked;
    private final FilterCache myChildren;
    private TestProxy myParent;
    public static final Filter NOT_LEAF = Filter.LEAF.not();

    public TestProxy(@NotNull TestInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit2/TestProxy.<init> must not be null");
        }
        this.myState = TestState.DEFAULT;
        this.myPrinter = Printer.DEAF;
        this.myNotifier = new TestProxyListenersNotifier();
        this.myStatistics = new Statistics();
        this.myPreviousMagnitude = -1;
        this.myStateTimestamp = 0;
        this.myMarked = false;
        this.myChildren = new FilterCache();
        this.myParent = null;
        this.myInfo = info;
    }

    public String toString() {
        return this.getInfo().getComment() + "." + this.getInfo().getName();
    }

    public void onOutput(String text, ConsoleViewContentType contentType) {
        if (!this.myMarked && contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.myPrinter.mark();
            this.myMarked = true;
        }
        ExternalOutput printable = new ExternalOutput(text, contentType);
        this.addLast((Printable)printable);
    }

    public void addLast(Printable printable) {
        super.addLast(printable);
        this.fireOnNewPrintable(printable);
    }

    private void fireOnNewPrintable(Printable printable) {
        this.myPrinter.onNewAvailable(printable);
    }

    public void printOn(Printer printer) {
        super.printOn(printer);
        CompositePrintable.printAllOn(this.myChildren.getList(), (Printer)printer);
        this.myState.printOn(printer);
    }

    public TestState getState() {
        return this.myState;
    }

    public void setState(TestState state) {
        if (this.myState != state) {
            this.fireOnNewPrintable(state);
            if (this.myState != null) {
                state.merge(this.myState);
            }
            this.myState = state;
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
        ++this.myStateTimestamp;
        this.pullEvent(new StateChangedEvent(this));
        if (this.myParent != null) {
            this.myParent.onChanged((AbstractTestProxy)this);
        }
        this.myNotifier.onChanged((AbstractTestProxy)this);
    }

    public int getStateTimestamp() {
        return this.myStateTimestamp;
    }

    public TestProxy getChildAt(int childIndex) {
        return this.myChildren.getList().get(childIndex);
    }

    public int getChildCount() {
        return this.myChildren.getList().size();
    }

    public List<TestProxy> getChildren() {
        return this.myChildren.getUnmodifiableList();
    }

    public TestProxy getParent() {
        return this.myParent;
    }

    public Navigatable getDescriptor(Location location) {
        return this.getState().getDescriptor(location);
    }

    public String getName() {
        return this.getInfo().getName();
    }

    public boolean isInProgress() {
        return this.getState().isInProgress();
    }

    public boolean isDefect() {
        return this.getState().isDefect();
    }

    public boolean shouldRun() {
        return this.getInfo().shouldRun();
    }

    public int getMagnitude() {
        return this.getState().getMagnitude();
    }

    public Location getLocation(Project project) {
        return this.getInfo().getLocation(project);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isPassed() {
        return this.getMagnitude() <= 1;
    }

    public void addChild(TestProxy child) {
        if (this.myChildren.contains(child)) {
            return;
        }
        if (child.getParent() != null) {
            return;
        }
        this.myChildren.add(child);
        child.myParent = this;
        if (this.myPrinter != Printer.DEAF) {
            child.setPrintLinstener(this.myPrinter);
            child.fireOnNewPrintable((Printable)child);
        }
        this.pullEvent(new NewChildEvent(this, child));
        this.getState().changeStateAfterAddingChildTo(this, child);
        this.myNotifier.onChildAdded((AbstractTestProxy)this, (AbstractTestProxy)child);
    }

    public void setPrintLinstener(Printer printer) {
        this.myPrinter = printer;
        Iterator iterator = this.myChildren.iterator();
        while (iterator.hasNext()) {
            TestProxy testProxy = (TestProxy)((Object)iterator.next());
            testProxy.setPrintLinstener(printer);
        }
    }

    public TestInfo getInfo() {
        return this.myInfo;
    }

    public void onChanged(AbstractTestProxy test) {
        this.myChildren.resetCache();
        int magnitude = test.getMagnitude();
        this.getState().update();
        if (this.myPreviousMagnitude < magnitude || this.getState().getMagnitude() <= magnitude) {
            this.fireStateChanged();
            this.myPreviousMagnitude = this.getState().getMagnitude();
        }
    }

    public void onStatisticsChanged() {
        this.myChildren.resetCache();
        if (this.myParent != null) {
            this.myParent.onStatisticsChanged();
        }
        this.pullEvent(new StatisticsChanged(this));
        this.myNotifier.onStatisticsChanged((AbstractTestProxy)this);
    }

    public void addListener(TestProxyListener listener) {
        this.myNotifier.addListener(listener);
    }

    public void setStatistics(Statistics statistics) {
        if (!this.myState.isFinal()) {
            LOG.error(String.valueOf(this.myState.getMagnitude()));
        }
        this.myStatistics = statistics;
        this.onStatisticsChanged();
    }

    public Statistics getStatisticsImpl() {
        return this.myStatistics;
    }

    public boolean hasChildSuites() {
        return this.myChildren.detect(NOT_LEAF) != null;
    }

    public Statistics getStatistics() {
        return this.myState.getStatisticsFor(this);
    }

    public TestProxy[] selectChildren(Filter filter) {
        return this.myChildren.select(filter);
    }

    public void setEventsConsumer(TestEventsConsumer eventsConsumer) {
        this.myEventsConsumer = eventsConsumer;
    }

    private void pullEvent(TestEvent event) {
        if (this.myEventsConsumer != null) {
            this.myEventsConsumer.onEvent(event);
            return;
        }
        if (this.myParent != null) {
            this.myParent.pullEvent(event);
        }
    }

    public List<TestProxy> getAllTests() {
        return this.myState.getAllTestsOf(this);
    }

    public void collectAllTestsTo(ArrayList<TestProxy> allTests) {
        allTests.add(this);
        Iterator iterator = this.myChildren.iterator();
        while (iterator.hasNext()) {
            TestProxy testProxy = (TestProxy)((Object)iterator.next());
            testProxy.collectAllTestsTo(allTests);
        }
    }

    public TestProxy getCommonAncestor(TestProxy test) {
        if (test == null) {
            return this;
        }
        if (test.isAncestorOf(this)) {
            return test;
        }
        for (TestProxy parent = this; parent != null; parent = parent.getParent()) {
            if (!parent.isAncestorOf(test)) continue;
            return parent;
        }
        return null;
    }

    public boolean isAncestorOf(TestProxy test) {
        if (test == null) {
            return false;
        }
        for (TestProxy parent = test; parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    public AbstractTestProxy[] getPathFromRoot() {
        ArrayList<TestProxy> parents = new ArrayList<TestProxy>();
        TestProxy test = this;
        do {
            parents.add(test);
        } while ((test = test.getParent()) != null);
        Collections.reverse(parents);
        return (AbstractTestProxy[])parents.toArray(new TestProxy[parents.size()]);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }
}

