/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFramework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;

public class JUnitTestFramework
implements TestFramework {
    public boolean isTestKlass(PsiClass psiClass) {
        return JUnitUtil.isTestClass((PsiClass)psiClass);
    }

    public PsiMethod findSetUpMethod(PsiClass psiClass) throws IncorrectOperationException {
        PsiMethod inClass;
        PsiMethod baseMethod;
        PsiManager manager = psiClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        if (JUnitUtil.isJUnit4TestClass((PsiClass)psiClass)) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = psiClass.getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Before", (boolean)false)) continue;
                return method;
            }
            PsiMethod method = (PsiMethod)psiClass.add((PsiElement)factory.createMethodFromText("@org.junit.Before public void setUp() throws Exception {\n}", null));
            JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)method);
            return method;
        }
        PsiMethod patternMethod = factory.createMethodFromText("protected void setUp() throws Exception {\nsuper.setUp();\n}", null);
        PsiClass baseClass = psiClass.getSuperClass();
        if (baseClass != null && (baseMethod = baseClass.findMethodBySignature(patternMethod, false)) != null && baseMethod.hasModifierProperty("public")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"protected", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"public", (boolean)true);
        }
        if ((inClass = psiClass.findMethodBySignature(patternMethod, false)) == null) {
            return (PsiMethod)psiClass.add((PsiElement)patternMethod);
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public boolean isTestMethodOrConfig(PsiMethod psiMethod) {
        return JUnitUtil.isTestMethodOrConfig((PsiMethod)psiMethod);
    }
}

