/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnitConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements RunJavaConfiguration,
RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit.JUnitConfiguration");
    public static final String DEFAULT_PACKAGE_NAME = ExecutionBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);
    @NonNls
    public static final String TEST_CLASS = "class";
    @NonNls
    public static final String TEST_PACKAGE = "package";
    @NonNls
    public static final String TEST_METHOD = "method";
    private final Data myData;
    @NonNls
    public static final String JUNIT_START_CLASS = "com.intellij.rt.execution.junit.JUnitStarter";
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    final RefactoringListeners.Accessor<PsiPackage> myPackage = new RefactoringListeners.Accessor<PsiPackage>(){

        public void setName(String qualifiedName) {
            boolean generatedName = JUnitConfiguration.this.isGeneratedName();
            ((JUnitConfiguration)JUnitConfiguration.this).myData.PACKAGE_NAME = qualifiedName;
            if (generatedName) {
                JUnitConfiguration.this.setGeneratedName();
            }
        }

        public PsiPackage getPsiElement() {
            String qualifiedName = JUnitConfiguration.this.myData.getPackageName();
            return qualifiedName != null ? JavaPsiFacade.getInstance((Project)JUnitConfiguration.this.getProject()).findPackage(qualifiedName) : null;
        }

        public void setPsiElement(PsiPackage psiPackage) {
            this.setName(psiPackage.getQualifiedName());
        }
    };
    final RefactoringListeners.Accessor<PsiClass> myClass = new RefactoringListeners.Accessor<PsiClass>(){

        public void setName(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/JUnitConfiguration$2.setName must not be null");
            }
            boolean generatedName = JUnitConfiguration.this.isGeneratedName();
            ((JUnitConfiguration)JUnitConfiguration.this).myData.MAIN_CLASS_NAME = qualifiedName;
            if (generatedName) {
                JUnitConfiguration.this.setGeneratedName();
            }
        }

        public PsiClass getPsiElement() {
            return ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).findClass(JUnitConfiguration.this.myData.getMainClassName());
        }

        public void setPsiElement(PsiClass psiClass) {
            Module originalModule = ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).getModule();
            JUnitConfiguration.this.setMainClass(psiClass);
            JUnitConfiguration.this.restoreOriginalModule(originalModule);
        }
    };

    public JUnitConfiguration(String name, Project project, ConfigurationFactory configurationFactory) {
        this(name, project, new Data(), configurationFactory);
    }

    private JUnitConfiguration(String name, Project project, Data data, ConfigurationFactory configurationFactory) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, false), configurationFactory);
        this.myData = data;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/JUnitConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/junit/JUnitConfiguration.getState must not be null");
        }
        return TestObject.fromString(this.myData.TEST_OBJECT, this.getProject(), this, env.getRunnerSettings(), env.getConfigurationSettings());
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JUnitConfigurable(this.getProject()));
        RunConfigurationExtension.appendEditors((ModuleBasedConfiguration)this, (SettingsEditorGroup)group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return group;
    }

    public Data getPersistentData() {
        return this.myData;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return this.myData.getTestObject(this.getProject(), this).getListener(element, this);
    }

    public String getGeneratedName() {
        return this.myData.getGeneratedName((JavaRunConfigurationModule)this.getConfigurationModule());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.myData.getTestObject(this.getProject(), this).checkConfiguration();
        RunConfigurationExtension.checkConfigurationIsValid((ModuleBasedConfiguration)this);
    }

    public Collection<Module> getValidModules() {
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT)) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        try {
            this.myData.getTestObject(this.getProject(), this).checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.myData.getMainClassName());
    }

    protected ModuleBasedConfiguration createInstance() {
        return new JUnitConfiguration(this.getName(), this.getProject(), this.myData.clone(), JUnitConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    public boolean isGeneratedName() {
        String name = this.getName();
        return this.myData.isGeneratedName(name, (JavaRunConfigurationModule)this.getConfigurationModule());
    }

    public String suggestedName() {
        return this.getTestObject().suggestActionName();
    }

    public void setProperty(int property, String value) {
        this.myData.setProperty(property, value);
    }

    public String getProperty(int property) {
        return this.myData.getProperty(property);
    }

    public void beClassConfiguration(PsiClass testClass) {
        this.setMainClass(testClass);
        this.myData.TEST_OBJECT = TEST_CLASS;
        this.setGeneratedName();
    }

    public void setMainClass(PsiClass testClass) {
        boolean shouldUpdateName = this.isGeneratedName();
        this.setModule(this.myData.setMainClass(testClass));
        if (shouldUpdateName) {
            this.setGeneratedName();
        }
    }

    public void setGeneratedName() {
        this.setName(this.getGeneratedName());
    }

    public void beMethodConfiguration(Location<PsiMethod> methodLocation) {
        this.setModule(this.myData.setTestMethod(methodLocation));
        this.setGeneratedName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Module[] getModules() {
        Module[] moduleArray;
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT) && this.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            moduleArray = Module.EMPTY_ARRAY;
            if (Module.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/execution/junit/JUnitConfiguration.getModules must not return null");
            return moduleArray;
        }
        moduleArray = super.getModules();
        if (moduleArray != null) return moduleArray;
        throw new IllegalStateException("@NotNull method com/intellij/execution/junit/JUnitConfiguration.getModules must not return null");
    }

    public TestObject getTestObject() {
        return this.myData.getTestObject(this.getProject(), this);
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        RunConfigurationExtension.readSettings((ModuleBasedConfiguration)this, (Element)element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.readExternal((Object)this.getPersistentData(), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getPersistentData().getEnvs());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        RunConfigurationExtension.writeSettings((ModuleBasedConfiguration)this, (Element)element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.writeExternal((Object)this.getPersistentData(), (Element)element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getPersistentData().getEnvs());
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    public void configureClasspath(JavaParameters javaParameters) throws CantRunException {
        RunConfigurationModule module = this.getConfigurationModule();
        String jreHome = this.isAlternativeJrePathEnabled() ? this.getAlternativeJrePath() : null;
        int pathType = 7;
        if (this.myData.getScope() == TestSearchScope.WHOLE_PROJECT) {
            JavaParametersUtil.configureProject((Project)module.getProject(), (JavaParameters)javaParameters, (int)7, (String)jreHome);
        } else {
            JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)javaParameters, (int)7, (String)jreHome);
        }
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String ALTERNATIVE_JRE_PATH) {
        this.ALTERNATIVE_JRE_PATH = ALTERNATIVE_JRE_PATH;
    }

    public String getRunClass() {
        Data data = this.getPersistentData();
        return data.TEST_OBJECT != TEST_CLASS && data.TEST_OBJECT != TEST_METHOD ? null : data.getMainClassName();
    }

    public String getPackage() {
        Data data = this.getPersistentData();
        return data.TEST_OBJECT != TEST_PACKAGE ? null : data.getPackageName();
    }

    public static class Data
    implements Cloneable {
        public String PACKAGE_NAME;
        public String MAIN_CLASS_NAME;
        public String METHOD_NAME;
        public String TEST_OBJECT = "class";
        public String VM_PARAMETERS;
        public String PARAMETERS;
        public String WORKING_DIRECTORY;
        public String ENV_VARIABLES;
        private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
        public boolean PASS_PARENT_ENVS = true;
        public TestSearchScope.Wrapper TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();

        public boolean equals(Object object) {
            if (!(object instanceof Data)) {
                return false;
            }
            Data second = (Data)object;
            return Comparing.equal((String)this.TEST_OBJECT, (String)second.TEST_OBJECT) && Comparing.equal((String)this.getMainClassName(), (String)second.getMainClassName()) && Comparing.equal((String)this.getPackageName(), (String)second.getPackageName()) && Comparing.equal((String)this.getMethodName(), (String)second.getMethodName()) && Comparing.equal((String)this.getWorkingDirectory(), (String)second.getWorkingDirectory()) && Comparing.equal((String)this.VM_PARAMETERS, (String)second.VM_PARAMETERS) && Comparing.equal((String)this.PARAMETERS, (String)second.PARAMETERS);
        }

        public int hashCode() {
            return Comparing.hashcode((Object)this.TEST_OBJECT) ^ Comparing.hashcode((Object)this.getMainClassName()) ^ Comparing.hashcode((Object)this.getPackageName()) ^ Comparing.hashcode((Object)this.getMethodName()) ^ Comparing.hashcode((Object)this.getWorkingDirectory()) ^ Comparing.hashcode((Object)this.VM_PARAMETERS) ^ Comparing.hashcode((Object)this.PARAMETERS);
        }

        public TestSearchScope getScope() {
            return this.TEST_SEARCH_SCOPE.getScope();
        }

        public Data clone() {
            try {
                Data data = (Data)super.clone();
                data.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
                data.setScope(this.getScope());
                return data;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Module setTestMethod(Location<PsiMethod> methodLocation) {
            PsiMethod method = (PsiMethod)methodLocation.getPsiElement();
            this.METHOD_NAME = method.getName();
            this.TEST_OBJECT = JUnitConfiguration.TEST_METHOD;
            return this.setMainClass(methodLocation instanceof MethodLocation ? ((MethodLocation)methodLocation).getContainingClass() : method.getContainingClass());
        }

        public String getProperty(int property) {
            switch (property) {
                case 1: {
                    return this.PARAMETERS;
                }
                case 0: {
                    return this.VM_PARAMETERS;
                }
                case 2: {
                    return this.getWorkingDirectory();
                }
            }
            throw new RuntimeException("Unknown property: " + property);
        }

        private String getWorkingDirectory() {
            return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
        }

        public void setProperty(int property, String value) {
            switch (property) {
                case 1: {
                    this.PARAMETERS = value;
                    break;
                }
                case 0: {
                    this.VM_PARAMETERS = value;
                    break;
                }
                case 2: {
                    this.WORKING_DIRECTORY = ExternalizablePath.urlValue((String)value);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown property: " + property);
                }
            }
        }

        public boolean isGeneratedName(String name, JavaRunConfigurationModule configurationModule) {
            if (this.TEST_OBJECT == null) {
                return true;
            }
            if ((JUnitConfiguration.TEST_CLASS.equals(this.TEST_OBJECT) || JUnitConfiguration.TEST_METHOD.equals(this.TEST_OBJECT)) && this.getMainClassName().length() == 0) {
                return JavaExecutionUtil.isNewName((String)name);
            }
            if (JUnitConfiguration.TEST_METHOD.equals(this.TEST_OBJECT) && this.getMethodName().length() == 0) {
                return JavaExecutionUtil.isNewName((String)name);
            }
            return Comparing.equal((String)name, (String)this.getGeneratedName(configurationModule));
        }

        public String getGeneratedName(JavaRunConfigurationModule configurationModule) {
            if (JUnitConfiguration.TEST_PACKAGE.equals(this.TEST_OBJECT)) {
                String moduleName = this.TEST_SEARCH_SCOPE.getScope() == TestSearchScope.WHOLE_PROJECT ? "" : configurationModule.getModuleName();
                String packageName = this.getPackageName();
                if (packageName.length() == 0) {
                    if (moduleName.length() > 0) {
                        return ExecutionBundle.message((String)"default.junit.config.name.all.in.module", (Object[])new Object[]{moduleName});
                    }
                    return DEFAULT_PACKAGE_NAME;
                }
                if (moduleName.length() > 0) {
                    return ExecutionBundle.message((String)"default.junit.config.name.all.in.package.in.module", (Object[])new Object[]{packageName, moduleName});
                }
                return packageName;
            }
            String className = JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName(), (JavaRunConfigurationModule)configurationModule);
            if (JUnitConfiguration.TEST_METHOD.equals(this.TEST_OBJECT)) {
                return className + '.' + this.getMethodName();
            }
            return className;
        }

        public String getMainClassName() {
            return this.MAIN_CLASS_NAME != null ? this.MAIN_CLASS_NAME : "";
        }

        public String getPackageName() {
            return this.PACKAGE_NAME != null ? this.PACKAGE_NAME : "";
        }

        public String getMethodName() {
            return this.METHOD_NAME != null ? this.METHOD_NAME : "";
        }

        public TestObject getTestObject(Project project, JUnitConfiguration configuration) {
            return TestObject.fromString(this.TEST_OBJECT, project, configuration, null, null);
        }

        public Module setMainClass(PsiClass testClass) {
            this.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)testClass);
            PsiPackage containingPackage = JUnitUtil.getContainingPackage((PsiClass)testClass);
            this.PACKAGE_NAME = containingPackage != null ? containingPackage.getQualifiedName() : "";
            return JavaExecutionUtil.findModule((PsiClass)testClass);
        }

        public void setScope(TestSearchScope scope) {
            this.TEST_SEARCH_SCOPE.setScope(scope);
        }

        public Map<String, String> getEnvs() {
            return this.myEnvs;
        }

        public void setEnvs(Map<String, String> envs) {
            this.myEnvs = envs;
        }
    }
}

