/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;

public class MavenEnvironmentRegistrar
implements ApplicationComponent {
    private static final String MAVEN_REPOSITORY = "MAVEN_REPOSITORY";

    @NotNull
    public String getComponentName() {
        String string = MavenEnvironmentRegistrar.class.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/utils/MavenEnvironmentRegistrar.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
        this.registerFileTypes();
        this.registerPathVariable();
    }

    private void registerFileTypes() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        FileTypeManager.getInstance().associateExtension((FileType)XmlFileType.INSTANCE, "pom");
    }

    private void registerPathVariable() {
        File repository = MavenEmbedderFactory.resolveLocalRepository(null, null, null);
        PathMacros macros = PathMacros.getInstance();
        for (String each : macros.getAllMacroNames()) {
            String path = macros.getValue(each);
            if (path == null || !new File(path).equals(repository)) continue;
            return;
        }
        macros.setMacro(MAVEN_REPOSITORY, repository.getPath());
    }

    public void disposeComponent() {
    }
}

