/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProfileState;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public class MavenProjectsTree {
    private static final String STORAGE_VERSION = MavenProjectsTree.class.getSimpleName() + ".5";
    private final Object myStateLock = new Object();
    private final ReentrantReadWriteLock myStructureLock = new ReentrantReadWriteLock();
    private final Lock myStructureReadLock = this.myStructureLock.readLock();
    private final Lock myStructureWriteLock = this.myStructureLock.writeLock();
    private volatile List<String> myManagedFilesPaths = new ArrayList<String>();
    private volatile List<String> myIgnoredFilesPaths = new ArrayList<String>();
    private volatile List<String> myIgnoredFilesPatterns = new ArrayList<String>();
    private volatile Pattern myIgnoredFilesPatternsCache;
    private volatile Set<String> myExplicitProfiles = new THashSet();
    private volatile Set<String> myTemporarilyRemovedExplicitProfiles = new THashSet();
    private final List<MavenProject> myRootProjects = new ArrayList<MavenProject>();
    private final Map<MavenProject, MavenProjectTimestamp> myTimestamps = new THashMap();
    private final Map<VirtualFile, MavenProject> myVirtualFileToProjectMapping = new THashMap();
    private final Map<MavenId, MavenProject> myMavenIdToProjectMapping = new THashMap();
    private final Map<MavenId, VirtualFile> myMavenIdToFileMapping = new THashMap();
    private final Map<MavenProject, List<MavenProject>> myAggregatorToModuleMapping = new THashMap();
    private final Map<MavenProject, MavenProject> myModuleToAggregatorMapping = new THashMap();
    private final List<Listener> myListeners = ContainerUtil.createEmptyCOWList();
    private final MavenProjectReaderProjectLocator myProjectLocator = new MavenProjectReaderProjectLocator(){

        @Override
        public VirtualFile findProjectFile(MavenId coordinates) {
            MavenProject project = MavenProjectsTree.this.findProject(coordinates);
            return project == null ? null : project.getFile();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MavenProjectsTree read(File file) throws IOException {
        FileInputStream fs = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fs);
        MavenProjectsTree result = new MavenProjectsTree();
        try {
            if (!STORAGE_VERSION.equals(in.readUTF())) {
                MavenProjectsTree mavenProjectsTree = null;
                return mavenProjectsTree;
            }
            try {
                result.myManagedFilesPaths = MavenProjectsTree.readList(in);
                result.myIgnoredFilesPaths = MavenProjectsTree.readList(in);
                result.myIgnoredFilesPatterns = MavenProjectsTree.readList(in);
                result.myExplicitProfiles = MavenProjectsTree.readCollection(in, new Function<Integer, Set<String>>(){

                    public Set<String> fun(Integer integer) {
                        return new THashSet(integer.intValue());
                    }
                });
                result.myRootProjects.addAll(MavenProjectsTree.readProjectsRecursively(in, result));
            }
            catch (Throwable e) {
                IOException ioException = new IOException();
                ioException.initCause(e);
                throw ioException;
            }
        }
        finally {
            in.close();
            fs.close();
        }
        return result;
    }

    private static List<String> readList(DataInputStream in) throws IOException {
        return MavenProjectsTree.readCollection(in, new Function<Integer, List<String>>(){

            public List<String> fun(Integer integer) {
                return new ArrayList<String>(integer);
            }
        });
    }

    private static <T extends Collection<String>> T readCollection(DataInputStream in, Function<Integer, T> factory) throws IOException {
        int count = in.readInt();
        Collection result = (Collection)factory.fun((Object)count);
        while (count-- > 0) {
            result.add(in.readUTF());
        }
        return (T)result;
    }

    private static List<MavenProject> readProjectsRecursively(DataInputStream in, MavenProjectsTree tree) throws IOException {
        int count = in.readInt();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(count);
        while (count-- > 0) {
            MavenProject project = MavenProject.read(in);
            MavenProjectTimestamp timestamp = MavenProjectTimestamp.read(in);
            List<MavenProject> modules = MavenProjectsTree.readProjectsRecursively(in, tree);
            if (project == null) continue;
            result.add(project);
            tree.myTimestamps.put(project, timestamp);
            tree.myVirtualFileToProjectMapping.put(project.getFile(), project);
            tree.myMavenIdToProjectMapping.put(project.getMavenId(), project);
            tree.myMavenIdToFileMapping.put(project.getMavenId(), project.getFile());
            tree.myAggregatorToModuleMapping.put(project, modules);
            for (MavenProject eachModule : modules) {
                tree.myModuleToAggregatorMapping.put(eachModule, project);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        Object object = this.myStateLock;
        synchronized (object) {
            this.readLock();
            try {
                file.getParentFile().mkdirs();
                FileOutputStream fs = new FileOutputStream(file);
                DataOutputStream out = new DataOutputStream(fs);
                try {
                    out.writeUTF(STORAGE_VERSION);
                    MavenProjectsTree.writeCollection(out, this.myManagedFilesPaths);
                    MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPaths);
                    MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPatterns);
                    MavenProjectsTree.writeCollection(out, this.myExplicitProfiles);
                    this.writeProjectsRecursively(out, this.myRootProjects);
                }
                finally {
                    out.close();
                    fs.close();
                }
            }
            finally {
                this.readUnlock();
            }
        }
    }

    private static void writeCollection(DataOutputStream out, Collection<String> list) throws IOException {
        out.writeInt(list.size());
        for (String each : list) {
            out.writeUTF(each);
        }
    }

    private void writeProjectsRecursively(DataOutputStream out, List<MavenProject> list) throws IOException {
        out.writeInt(list.size());
        for (MavenProject each : list) {
            each.write(out);
            this.myTimestamps.get(each).write(out);
            this.writeProjectsRecursively(out, this.getModules(each));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getManagedFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myManagedFilesPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetManagedFilesPathsAndProfiles(List<String> paths, Collection<String> profiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths = new ArrayList<String>(paths);
        }
        this.setExplicitProfiles(profiles);
    }

    public void resetManagedFilesAndProfiles(List<VirtualFile> files, Collection<String> profiles) {
        this.resetManagedFilesPathsAndProfiles(MavenUtil.collectPaths(files), profiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedFilesWithProfiles(List<VirtualFile> files, Collection<String> profiles) {
        THashSet newProfiles;
        ArrayList<String> newFiles;
        Object object = this.myStateLock;
        synchronized (object) {
            newFiles = new ArrayList<String>(this.myManagedFilesPaths);
            newFiles.addAll(MavenUtil.collectPaths(files));
            newProfiles = new THashSet(this.myExplicitProfiles);
            newProfiles.addAll(profiles);
        }
        this.resetManagedFilesPathsAndProfiles(newFiles, (Collection<String>)newProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedFiles(List<VirtualFile> files) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths.removeAll(MavenUtil.collectPaths(files));
        }
    }

    public List<VirtualFile> getExistingManagedFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : this.getManagedFilesPaths()) {
            VirtualFile f = LocalFileSystem.getInstance().findFileByPath(path);
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPaths);
        }
    }

    public void setIgnoredFilesPaths(final List<String> paths) {
        this.doChangeIgnoreStatus(new Runnable(){

            @Override
            public void run() {
                MavenProjectsTree.this.myIgnoredFilesPaths = new ArrayList(paths);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIgnoredState(MavenProject project) {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(project.getPath());
        }
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored) {
        this.setIgnoredState(projects, ignored, null);
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored, Object message) {
        this.doSetIgnoredState(projects, ignored, message);
    }

    private void doSetIgnoredState(List<MavenProject> projects, final boolean ignored, Object message) {
        final List<String> paths = MavenUtil.collectPaths(MavenUtil.collectFiles(projects));
        this.doChangeIgnoreStatus(new Runnable(){

            @Override
            public void run() {
                if (ignored) {
                    MavenProjectsTree.this.myIgnoredFilesPaths.addAll(paths);
                } else {
                    MavenProjectsTree.this.myIgnoredFilesPaths.removeAll(paths);
                }
            }
        }, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPatterns() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPatterns);
        }
    }

    public void setIgnoredFilesPatterns(final List<String> patterns) {
        this.doChangeIgnoreStatus(new Runnable(){

            @Override
            public void run() {
                MavenProjectsTree.this.myIgnoredFilesPatternsCache = null;
                MavenProjectsTree.this.myIgnoredFilesPatterns = new ArrayList(patterns);
            }
        });
    }

    private void doChangeIgnoreStatus(Runnable runnable) {
        this.doChangeIgnoreStatus(runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeIgnoreStatus(Runnable runnable, Object message) {
        List<MavenProject> ignoredAfter;
        List<MavenProject> ignoredBefore;
        Object object = this.myStateLock;
        synchronized (object) {
            ignoredBefore = this.getIgnoredProjects();
            runnable.run();
            ignoredAfter = this.getIgnoredProjects();
        }
        ArrayList<MavenProject> ignored = new ArrayList<MavenProject>(ignoredAfter);
        ignored.removeAll(ignoredBefore);
        ArrayList<MavenProject> unignored = new ArrayList<MavenProject>(ignoredBefore);
        unignored.removeAll(ignoredAfter);
        if (ignored.isEmpty() && unignored.isEmpty()) {
            return;
        }
        this.fireProjectsIgnoredStateChanged(ignored, unignored, message);
    }

    private List<MavenProject> getIgnoredProjects() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject each : this.getProjects()) {
            if (!this.isIgnored(each)) continue;
            result.add(each);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnored(MavenProject project) {
        String path = project.getPath();
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(path) || this.matchesIgnoredFilesPatterns(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesIgnoredFilesPatterns(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            if (this.myIgnoredFilesPatternsCache == null) {
                this.myIgnoredFilesPatternsCache = Pattern.compile(Strings.translateMasks(this.myIgnoredFilesPatterns));
            }
            return this.myIgnoredFilesPatternsCache.matcher(path).matches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getExplicitProfiles() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new THashSet(this.myExplicitProfiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitProfiles(Collection<String> explicitProfiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myExplicitProfiles = new THashSet(explicitProfiles);
        }
        this.fireProfilesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExplicitProfiles() {
        Collection<String> available = this.getAvailableProfiles();
        Object object = this.myStateLock;
        synchronized (object) {
            THashSet removedProfiles = new THashSet(this.myExplicitProfiles);
            removedProfiles.removeAll(available);
            this.myTemporarilyRemovedExplicitProfiles.addAll((Collection<String>)removedProfiles);
            THashSet restoredProfiles = new THashSet(this.myTemporarilyRemovedExplicitProfiles);
            restoredProfiles.retainAll(available);
            this.myTemporarilyRemovedExplicitProfiles.removeAll((Collection<?>)restoredProfiles);
            this.myExplicitProfiles.removeAll((Collection<?>)removedProfiles);
            this.myExplicitProfiles.addAll((Collection<String>)restoredProfiles);
        }
    }

    public Collection<String> getAvailableProfiles() {
        return (Collection)this.getAvailableAndActiveProfiles((boolean)true, (boolean)false).first;
    }

    private Pair<Collection<String>, Collection<String>> getAvailableAndActiveProfiles(boolean includeAvailable, boolean includeActive) {
        THashSet available = includeAvailable ? new THashSet() : null;
        THashSet active = includeActive ? new THashSet() : null;
        for (MavenProject each : this.getProjects()) {
            if (available != null) {
                available.addAll(each.getProfilesIds());
            }
            if (active == null) continue;
            active.addAll(each.getActiveProfilesIds());
        }
        return Pair.create((Object)available, (Object)active);
    }

    public Collection<Pair<String, MavenProfileState>> getProfilesWithStates() {
        ArrayListSet result = new ArrayListSet();
        Pair<Collection<String>, Collection<String>> profiles = this.getAvailableAndActiveProfiles(true, true);
        Collection available = (Collection)profiles.first;
        Collection active = (Collection)profiles.second;
        Collection<String> explicitProfiles = this.getExplicitProfiles();
        for (String each : available) {
            MavenProfileState state = MavenProfileState.NONE;
            if (explicitProfiles.contains(each)) {
                state = MavenProfileState.EXPLICIT;
            } else if (active.contains(each)) {
                state = MavenProfileState.IMPLICIT;
            }
            result.add(Pair.create((Object)each, (Object)((Object)state)));
        }
        return result;
    }

    public void updateAll(boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process, Object message) {
        List<VirtualFile> managedFiles = this.getExistingManagedFiles();
        Collection<String> explicitProfiles = this.getExplicitProfiles();
        MavenProjectReader projectReader = new MavenProjectReader();
        this.update(managedFiles, true, force, explicitProfiles, projectReader, generalSettings, process, message);
        List<VirtualFile> obsoleteFiles = this.getRootProjectsFiles();
        obsoleteFiles.removeAll(managedFiles);
        this.delete(projectReader, obsoleteFiles, explicitProfiles, generalSettings, process, message);
    }

    public void update(Collection<VirtualFile> files, boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process, Object message) {
        this.update(files, false, force, this.getExplicitProfiles(), new MavenProjectReader(), generalSettings, process, message);
    }

    private void update(Collection<VirtualFile> files, boolean recursive, boolean force, Collection<String> explicitProfiles, MavenProjectReader projectReader, MavenGeneralSettings generalSettings, MavenProgressIndicator process, Object message) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        for (VirtualFile each : files) {
            MavenProject mavenProject = this.findProject(each);
            if (mavenProject == null) {
                this.doAdd(each, recursive, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process);
                continue;
            }
            this.doUpdate(mavenProject, this.findAggregator(mavenProject), false, recursive, force, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary(message);
    }

    private void doAdd(VirtualFile f, boolean recursuve, Collection<String> explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        MavenProject newMavenProject = new MavenProject(f);
        MavenProject intendedAggregator = null;
        for (MavenProject each : this.getProjects()) {
            if (!each.getExistingModuleFiles().contains(f)) continue;
            intendedAggregator = each;
            break;
        }
        this.doUpdate(newMavenProject, intendedAggregator, true, recursuve, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(MavenProject mavenProject, MavenProject aggregator, boolean isNew, boolean recursive, boolean force, Collection<String> explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        MavenProjectChanges changes;
        if (updateStack.contains((Object)mavenProject)) {
            MavenLog.LOG.info("Recursion detected in " + mavenProject.getFile());
            return;
        }
        updateStack.push((Object)mavenProject);
        process.setText(ProjectBundle.message("maven.reading.pom", mavenProject.getPath()));
        process.setText2("");
        List<MavenProject> prevModules = this.getModules(mavenProject);
        Object prevInheritors = isNew ? new THashSet() : this.findInheritors(mavenProject);
        MavenProjectTimestamp timestamp = this.calculateTimestamp(mavenProject, explicitProfiles, generalSettings);
        boolean isChanged = force || !timestamp.equals(this.myTimestamps.get(mavenProject));
        MavenProjectChanges mavenProjectChanges = changes = force ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
        if (isChanged) {
            this.writeLock();
            try {
                if (!isNew) {
                    this.myMavenIdToProjectMapping.remove(mavenProject.getMavenId());
                    this.myMavenIdToFileMapping.remove(mavenProject.getMavenId());
                }
            }
            finally {
                this.writeUnlock();
            }
            MavenId oldParentId = mavenProject.getParentId();
            changes = changes.mergedWith(mavenProject.read(generalSettings, explicitProfiles, reader, this.myProjectLocator));
            this.writeLock();
            try {
                this.myVirtualFileToProjectMapping.put(mavenProject.getFile(), mavenProject);
                this.myMavenIdToProjectMapping.put(mavenProject.getMavenId(), mavenProject);
                this.myMavenIdToFileMapping.put(mavenProject.getMavenId(), mavenProject.getFile());
            }
            finally {
                this.writeUnlock();
            }
            if (!Comparing.equal((Object)oldParentId, (Object)mavenProject.getParentId())) {
                timestamp = this.calculateTimestamp(mavenProject, explicitProfiles, generalSettings);
            }
            this.myTimestamps.put(mavenProject, timestamp);
        }
        boolean reconnected = isNew;
        if (isNew) {
            this.connect(aggregator, mavenProject);
        } else {
            reconnected = this.reconnect(aggregator, mavenProject);
        }
        if (isChanged || reconnected) {
            updateContext.update(mavenProject, changes);
        }
        List<VirtualFile> existingModuleFiles = mavenProject.getExistingModuleFiles();
        ArrayList<MavenProject> modulesToRemove = new ArrayList<MavenProject>();
        ArrayList<MavenProject> modulesToBecomeRoots = new ArrayList<MavenProject>();
        for (MavenProject mavenProject2 : prevModules) {
            VirtualFile moduleFile = mavenProject2.getFile();
            if (existingModuleFiles.contains(moduleFile)) continue;
            if (this.isManagedFile(moduleFile)) {
                modulesToBecomeRoots.add(mavenProject2);
                continue;
            }
            modulesToRemove.add(mavenProject2);
        }
        for (MavenProject mavenProject3 : modulesToRemove) {
            this.removeModule(mavenProject, mavenProject3);
            this.doDelete(mavenProject, mavenProject3, updateContext);
            prevInheritors.removeAll(updateContext.deletedProjects);
        }
        for (MavenProject mavenProject4 : modulesToBecomeRoots) {
            if (!this.reconnect(null, mavenProject4)) continue;
            updateContext.update(mavenProject4, MavenProjectChanges.NONE);
        }
        for (VirtualFile virtualFile : existingModuleFiles) {
            boolean isNewModule;
            MavenProject module = this.findProject(virtualFile);
            boolean bl = isNewModule = module == null;
            if (isNewModule) {
                module = new MavenProject(virtualFile);
            } else {
                MavenProject currentAggregator = this.findAggregator(module);
                if (currentAggregator != null && currentAggregator != mavenProject) {
                    MavenLog.LOG.info("Module " + virtualFile + " is already included into " + mavenProject.getFile());
                    continue;
                }
            }
            if (isChanged || isNewModule || recursive) {
                this.doUpdate(module, mavenProject, isNewModule, recursive, recursive ? force : false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process);
                continue;
            }
            if (!this.reconnect(mavenProject, module)) continue;
            updateContext.update(module, MavenProjectChanges.NONE);
        }
        Set<MavenProject> allInheritors = this.findInheritors(mavenProject);
        allInheritors.addAll((Collection<MavenProject>)prevInheritors);
        for (MavenProject each : allInheritors) {
            this.doUpdate(each, this.findAggregator(each), false, false, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process);
        }
        updateStack.pop();
    }

    private MavenProjectTimestamp calculateTimestamp(final MavenProject mavenProject, final Collection<String> explicitProfiles, final MavenGeneralSettings generalSettings) {
        return (MavenProjectTimestamp)ApplicationManager.getApplication().runReadAction((Computable)new Computable<MavenProjectTimestamp>(){

            public MavenProjectTimestamp compute() {
                long pomTimestamp = MavenProjectsTree.this.getFileTimestamp(mavenProject.getFile());
                MavenProject parent = MavenProjectsTree.this.findParent(mavenProject);
                long parentLastReadStamp = parent == null ? -1L : parent.getLastReadStamp();
                VirtualFile profilesXmlFile = mavenProject.getProfilesXmlFile();
                long profilesTimestamp = MavenProjectsTree.this.getFileTimestamp(profilesXmlFile);
                long userSettingsTimestamp = MavenProjectsTree.this.getFileTimestamp(generalSettings.getEffectiveUserSettingsFile());
                long globalSettingsTimestamp = MavenProjectsTree.this.getFileTimestamp(generalSettings.getEffectiveGlobalSettingsFile());
                int profilesHashCode = ((Object)explicitProfiles).hashCode();
                return new MavenProjectTimestamp(pomTimestamp, parentLastReadStamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode);
            }
        });
    }

    private long getFileTimestamp(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return -1L;
        }
        return file.getTimeStamp();
    }

    public boolean isManagedFile(VirtualFile moduleFile) {
        return this.isManagedFile(moduleFile.getPath());
    }

    public boolean isManagedFile(String path) {
        for (String each : this.getManagedFilesPaths()) {
            if (!FileUtil.pathsEqual((String)each, (String)path)) continue;
            return true;
        }
        return false;
    }

    public boolean isPotentialProject(String path) {
        if (this.isManagedFile(path)) {
            return true;
        }
        for (MavenProject each : this.getProjects()) {
            if (FileUtil.pathsEqual((String)path, (String)each.getPath())) {
                return true;
            }
            if (!each.getModulePaths().contains(path)) continue;
            return true;
        }
        return false;
    }

    public void delete(List<VirtualFile> files, MavenGeneralSettings generalSettings, MavenProgressIndicator process, Object message) {
        this.delete(new MavenProjectReader(), files, this.getExplicitProfiles(), generalSettings, process, message);
    }

    private void delete(MavenProjectReader projectReader, List<VirtualFile> files, Collection<String> explicitProfiles, MavenGeneralSettings generalSettings, MavenProgressIndicator process, Object message) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        THashSet inheritorsToUpdate = new THashSet();
        for (Object each : files) {
            MavenProject mavenProject = this.findProject((VirtualFile)each);
            if (mavenProject == null) {
                return;
            }
            inheritorsToUpdate.addAll(this.findInheritors(mavenProject));
            this.doDelete(this.findAggregator(mavenProject), mavenProject, updateContext);
        }
        inheritorsToUpdate.removeAll(updateContext.deletedProjects);
        for (Object each : inheritorsToUpdate) {
            this.doUpdate((MavenProject)each, null, false, false, false, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(MavenProject aggregator, MavenProject project, UpdateContext updateContext) {
        for (MavenProject each : this.getModules(project)) {
            if (this.isManagedFile(each.getPath())) {
                if (!this.reconnect(null, each)) continue;
                updateContext.update(each, MavenProjectChanges.NONE);
                continue;
            }
            this.doDelete(project, each, updateContext);
        }
        this.writeLock();
        try {
            if (aggregator != null) {
                this.removeModule(aggregator, project);
            } else {
                this.myRootProjects.remove(project);
            }
            this.myTimestamps.remove(project);
            this.myVirtualFileToProjectMapping.remove(project.getFile());
            this.myMavenIdToProjectMapping.remove(project.getMavenId());
            this.myMavenIdToFileMapping.remove(project.getMavenId());
            this.myAggregatorToModuleMapping.remove(project);
            this.myModuleToAggregatorMapping.remove(project);
        }
        finally {
            this.writeUnlock();
        }
        updateContext.deleted(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(MavenProject newAggregator, MavenProject project) {
        this.writeLock();
        try {
            if (newAggregator != null) {
                this.addModule(newAggregator, project);
            } else {
                this.myRootProjects.add(project);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnect(MavenProject newAggregator, MavenProject project) {
        MavenProject prevAggregator = this.findAggregator(project);
        if (prevAggregator == newAggregator) {
            return false;
        }
        this.writeLock();
        try {
            if (prevAggregator != null) {
                this.removeModule(prevAggregator, project);
            } else {
                this.myRootProjects.remove(project);
            }
            if (newAggregator != null) {
                this.addModule(newAggregator, project);
            } else {
                this.myRootProjects.add(project);
            }
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProjects() {
        this.readLock();
        try {
            boolean bl = !this.myRootProjects.isEmpty();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getRootProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myRootProjects);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<VirtualFile> getRootProjectsFiles() {
        return MavenUtil.collectFiles(this.getRootProjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myVirtualFileToProjectMapping.values());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getNonIgnoredProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> result = new ArrayList<MavenProject>();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (this.isIgnored(each)) continue;
                result.add(each);
            }
            ArrayList<MavenProject> arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getProjectsFiles() {
        this.readLock();
        try {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myVirtualFileToProjectMapping.keySet());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProject findProject(VirtualFile f) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myVirtualFileToProjectMapping.get(f);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProject findProject(MavenId id) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myMavenIdToProjectMapping.get(id);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    public MavenProject findProject(MavenArtifact artifact) {
        return this.findProject(artifact.getMavenId());
    }

    public MavenProject findProject(Artifact artifact) {
        return this.findProject(new MavenId(artifact));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MavenId, VirtualFile> getProjectIdToFileMapping() {
        this.readLock();
        try {
            THashMap tHashMap = new THashMap(this.myMavenIdToFileMapping);
            return tHashMap;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProject findAggregator(MavenProject project) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myModuleToAggregatorMapping.get(project);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getModules(MavenProject aggregator) {
        this.readLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            ArrayList<MavenProject> arrayList = modules == null ? Collections.emptyList() : new ArrayList<MavenProject>(modules);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                modules = new ArrayList<MavenProject>();
                this.myAggregatorToModuleMapping.put(aggregator, modules);
            }
            modules.add(module);
            this.myModuleToAggregatorMapping.put(module, aggregator);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                return;
            }
            modules.remove(module);
            this.myModuleToAggregatorMapping.remove(module);
        }
        finally {
            this.writeUnlock();
        }
    }

    private MavenProject findParent(MavenProject project) {
        return this.findProject(project.getParentId());
    }

    public Set<MavenProject> findInheritors(MavenProject project) {
        THashSet result = new THashSet();
        MavenId id = project.getMavenId();
        for (MavenProject each : this.getProjects()) {
            if (each == project || !id.equals(each.getParentId())) continue;
            result.add(each);
        }
        return result;
    }

    public List<MavenProject> getDependentProjects(MavenProject project) {
        SmartList result = new SmartList();
        for (MavenProject eachProject : this.getProjects()) {
            if (eachProject == project || eachProject.findDependencies(project).isEmpty()) continue;
            result.add(eachProject);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(MavenProject mavenProject, MavenGeneralSettings generalSettings, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator process, Object message) throws MavenProcessCanceledException {
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.EmbedderKind.FOR_DEPENDENCIES_RESOLVE);
        embedder.customizeForResolve(this.getProjectIdToFileMapping(), console, process);
        try {
            process.checkCanceled();
            process.setText(ProjectBundle.message("maven.resolving.pom", mavenProject.getDisplayName()));
            process.setText2("");
            Pair<MavenProjectChanges, org.apache.maven.project.MavenProject> resolveResult = mavenProject.resolve(generalSettings, embedder, new MavenProjectReader(), this.myProjectLocator);
            this.fireProjectResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProject, (Object)resolveResult.first), (org.apache.maven.project.MavenProject)resolveResult.second, message);
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolvePlugins(MavenProject mavenProject, org.apache.maven.project.MavenProject nativeMavenProject, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator process) throws MavenProcessCanceledException {
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.EmbedderKind.FOR_PLUGINS_RESOLVE);
        embedder.customizeForResolve(console, process);
        embedder.clearCachesFor(mavenProject);
        try {
            for (MavenPlugin each : mavenProject.getDeclaredPlugins()) {
                process.checkCanceled();
                process.setText(ProjectBundle.message("maven.downloading.pom.plugins", mavenProject.getDisplayName()));
                embedder.resolvePlugin(each, nativeMavenProject, false);
            }
            this.firePluginsResolved(mavenProject);
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    public void resolveFolders(final MavenProject mavenProject, final MavenGeneralSettings generalSettings, final MavenImportingSettings importingSettings, MavenEmbeddersManager embeddersManager, final MavenConsole console, final MavenProgressIndicator process, final Object message) throws MavenProcessCanceledException {
        this.executeWithEmbedder(mavenProject, embeddersManager, MavenEmbeddersManager.EmbedderKind.FOR_FOLDERS_RESOLVE, console, process, new EmbedderTask(){

            @Override
            public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                process.checkCanceled();
                process.setText(ProjectBundle.message("maven.updating.folders.pom", mavenProject.getDisplayName()));
                process.setText2("");
                Pair<Boolean, MavenProjectChanges> resolveResult = mavenProject.resolveFolders(embedder, generalSettings, importingSettings, new MavenProjectReader(), console);
                if (((Boolean)resolveResult.first).booleanValue()) {
                    MavenProjectsTree.this.fireFoldersResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProject, (Object)resolveResult.second), message);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenArtifactDownloader.DownloadResult downloadArtifacts(Collection<MavenProject> projects, @Nullable Collection<MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator process) throws MavenProcessCanceledException {
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.EmbedderKind.FOR_DOWNLOAD);
        embedder.customizeForResolve(console, process);
        try {
            MavenArtifactDownloader.DownloadResult result = MavenArtifactDownloader.download(this, projects, artifacts, downloadSources, downloadDocs, embedder, process);
            for (MavenProject each : projects) {
                this.fireArtifactsDownloaded(each);
            }
            MavenArtifactDownloader.DownloadResult downloadResult = result;
            return downloadResult;
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenArtifact downloadArtifact(MavenProject mavenProject, MavenId id, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator process) throws MavenProcessCanceledException {
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.EmbedderKind.FOR_DOWNLOAD);
        embedder.customizeForResolve(console, process);
        try {
            Artifact artifact = embedder.resolve(id, "jar", null, mavenProject.getRemoteRepositories());
            artifact.setScope("compile");
            MavenArtifact mavenArtifact = new MavenArtifact(artifact, mavenProject.getLocalRepository());
            return mavenArtifact;
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithEmbedder(MavenProject mavenProject, MavenEmbeddersManager embeddersManager, MavenEmbeddersManager.EmbedderKind embedderKind, MavenConsole console, MavenProgressIndicator process, EmbedderTask task) throws MavenProcessCanceledException {
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(embedderKind);
        embedder.customizeForStrictResolve(this.getProjectIdToFileMapping(), console, process);
        embedder.clearCachesFor(mavenProject);
        try {
            task.run(embedder);
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    public <Result> Result visit(Visitor<Result> visitor) {
        for (MavenProject each : this.getRootProjects()) {
            if (visitor.isDone()) break;
            this.doVisit(each, visitor);
        }
        return visitor.getResult();
    }

    private <Result> void doVisit(MavenProject project, Visitor<Result> visitor) {
        if (!visitor.isDone() && visitor.shouldVisit(project)) {
            visitor.visit(project);
            for (MavenProject each : this.getModules(project)) {
                if (visitor.isDone()) break;
                this.doVisit(each, visitor);
            }
            visitor.leave(project);
        }
    }

    private void writeLock() {
        this.myStructureWriteLock.lock();
    }

    private void writeUnlock() {
        this.myStructureWriteLock.unlock();
    }

    private void readLock() {
        this.myStructureReadLock.lock();
    }

    private void readUnlock() {
        this.myStructureReadLock.unlock();
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    private void fireProfilesChanged() {
        for (Listener each : this.myListeners) {
            each.profilesChanged();
        }
    }

    private void fireProjectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, Object fromImport) {
        for (Listener each : this.myListeners) {
            each.projectsIgnoredStateChanged(ignored, unignored, fromImport);
        }
    }

    private void fireProjectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted, Object message) {
        for (Listener each : this.myListeners) {
            each.projectsUpdated(updated, deleted, message);
        }
    }

    private void fireProjectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, org.apache.maven.project.MavenProject nativeMavenProject, Object message) {
        for (Listener each : this.myListeners) {
            each.projectResolved(projectWithChanges, nativeMavenProject, message);
        }
    }

    private void firePluginsResolved(MavenProject project) {
        for (Listener each : this.myListeners) {
            each.pluginsResolved(project);
        }
    }

    private void fireFoldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, Object message) {
        for (Listener each : this.myListeners) {
            each.foldersResolved(projectWithChanges, message);
        }
    }

    private void fireArtifactsDownloaded(MavenProject project) {
        for (Listener each : this.myListeners) {
            each.artifactsDownloaded(project);
        }
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void profilesChanged() {
        }

        @Override
        public void projectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, Object message) {
        }

        @Override
        public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted, Object message) {
        }

        @Override
        public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, org.apache.maven.project.MavenProject nativeMavenProject, Object message) {
        }

        @Override
        public void pluginsResolved(MavenProject project) {
        }

        @Override
        public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, Object message) {
        }

        @Override
        public void artifactsDownloaded(MavenProject project) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void profilesChanged();

        public void projectsIgnoredStateChanged(List<MavenProject> var1, List<MavenProject> var2, Object var3);

        public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> var1, List<MavenProject> var2, Object var3);

        public void projectResolved(Pair<MavenProject, MavenProjectChanges> var1, org.apache.maven.project.MavenProject var2, Object var3);

        public void pluginsResolved(MavenProject var1);

        public void foldersResolved(Pair<MavenProject, MavenProjectChanges> var1, Object var2);

        public void artifactsDownloaded(MavenProject var1);
    }

    private static class MavenProjectTimestamp {
        private final long myPomTimestamp;
        private final long myParentLastReadStamp;
        private final long myProfilesTimestamp;
        private final long myUserSettingsTimestamp;
        private final long myGlobalSettingsTimestamp;
        private final long myExplicitProfilesHashCode;

        private MavenProjectTimestamp(long pomTimestamp, long parentLastReadStamp, long profilesTimestamp, long userSettingsTimestamp, long globalSettingsTimestamp, long explicitProfilesHashCode) {
            this.myPomTimestamp = pomTimestamp;
            this.myParentLastReadStamp = parentLastReadStamp;
            this.myProfilesTimestamp = profilesTimestamp;
            this.myUserSettingsTimestamp = userSettingsTimestamp;
            this.myGlobalSettingsTimestamp = globalSettingsTimestamp;
            this.myExplicitProfilesHashCode = explicitProfilesHashCode;
        }

        public static MavenProjectTimestamp read(DataInputStream in) throws IOException {
            return new MavenProjectTimestamp(in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeLong(this.myPomTimestamp);
            out.writeLong(this.myParentLastReadStamp);
            out.writeLong(this.myProfilesTimestamp);
            out.writeLong(this.myUserSettingsTimestamp);
            out.writeLong(this.myGlobalSettingsTimestamp);
            out.writeLong(this.myExplicitProfilesHashCode);
        }

        public String toString() {
            return "(" + this.myPomTimestamp + ":" + this.myParentLastReadStamp + ":" + this.myProfilesTimestamp + ":" + this.myUserSettingsTimestamp + ":" + this.myGlobalSettingsTimestamp + ":" + this.myExplicitProfilesHashCode + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenProjectTimestamp timestamp = (MavenProjectTimestamp)o;
            if (this.myPomTimestamp != timestamp.myPomTimestamp) {
                return false;
            }
            if (this.myParentLastReadStamp != timestamp.myParentLastReadStamp) {
                return false;
            }
            if (this.myProfilesTimestamp != timestamp.myProfilesTimestamp) {
                return false;
            }
            if (this.myUserSettingsTimestamp != timestamp.myUserSettingsTimestamp) {
                return false;
            }
            if (this.myGlobalSettingsTimestamp != timestamp.myGlobalSettingsTimestamp) {
                return false;
            }
            return this.myExplicitProfilesHashCode == timestamp.myExplicitProfilesHashCode;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)(this.myPomTimestamp ^ this.myPomTimestamp >>> 32);
            result = 31 * result + (int)(this.myParentLastReadStamp ^ this.myParentLastReadStamp >>> 32);
            result = 31 * result + (int)(this.myProfilesTimestamp ^ this.myProfilesTimestamp >>> 32);
            result = 31 * result + (int)(this.myUserSettingsTimestamp ^ this.myUserSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myGlobalSettingsTimestamp ^ this.myGlobalSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myExplicitProfilesHashCode ^ this.myExplicitProfilesHashCode >>> 32);
            return result;
        }
    }

    public static abstract class SimpleVisitor
    extends Visitor<Object> {
    }

    public static abstract class Visitor<Result> {
        private Result result;

        public boolean shouldVisit(MavenProject project) {
            return true;
        }

        public abstract void visit(MavenProject var1);

        public void leave(MavenProject node) {
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.result != null;
        }
    }

    public static interface EmbedderTask {
        public void run(MavenEmbedderWrapper var1) throws MavenProcessCanceledException;
    }

    private class UpdateContext {
        public final Map<MavenProject, MavenProjectChanges> updatedProjectsWithChanges = new LinkedHashMap<MavenProject, MavenProjectChanges>();
        public final Set<MavenProject> deletedProjects = new LinkedHashSet<MavenProject>();

        private UpdateContext() {
        }

        public void update(MavenProject project, MavenProjectChanges changes) {
            this.deletedProjects.remove(project);
            this.updatedProjectsWithChanges.put(project, changes.mergedWith(this.updatedProjectsWithChanges.get(project)));
        }

        public void deleted(MavenProject project) {
            this.updatedProjectsWithChanges.remove(project);
            this.deletedProjects.add(project);
        }

        public void deleted(Collection<MavenProject> projects) {
            for (MavenProject each : projects) {
                this.deleted(each);
            }
        }

        public void fireUpdatedIfNecessary(Object message) {
            if (this.updatedProjectsWithChanges.isEmpty() && this.deletedProjects.isEmpty()) {
                return;
            }
            MavenProjectsTree.this.fireProjectsUpdated(this.updatedProjectsWithChanges.isEmpty() ? Collections.EMPTY_LIST : MavenUtil.mapToList(this.updatedProjectsWithChanges), this.deletedProjects.isEmpty() ? Collections.EMPTY_LIST : new ArrayList<MavenProject>(this.deletedProjects), message);
        }
    }
}

