/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.importing.MavenDefaultModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenDefaultModelsProvider;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenModelsProvider;
import org.jetbrains.idea.maven.project.MavenProfileState;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManagerState;
import org.jetbrains.idea.maven.project.MavenProjectsManagerWatcher;
import org.jetbrains.idea.maven.project.MavenProjectsProcessor;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorArtifactsDownloadingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorEmptyTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorFoldersResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorPluginsResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.SimpleProjectComponent;

@State(name="MavenProjectsManager", storages={@Storage(id="default", file="$PROJECT_FILE$")})
public class MavenProjectsManager
extends SimpleProjectComponent
implements PersistentStateComponent<MavenProjectsManagerState>,
SettingsSavingComponent {
    private static final int IMPORT_DELAY = 1000;
    static final Object SCHEDULE_IMPORT_MESSAGE = "SCHEDULE_IMPORT_MESSAGE";
    static final Object FORCE_IMPORT_MESSAGE = "FORCE_IMPORT_MESSAGE";
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private MavenProjectsManagerState myState = new MavenProjectsManagerState();
    private MavenEmbeddersManager myEmbeddersManager;
    private MavenProjectsTree myProjectsTree;
    private MavenProjectsManagerWatcher myWatcher;
    private MavenProjectsProcessor myReadingProcessor;
    private MavenProjectsProcessor myResolvingProcessor;
    private MavenProjectsProcessor myPluginsResolvingProcessor;
    private MavenProjectsProcessor myFoldersResolvingProcessor;
    private MavenProjectsProcessor myArtifactsDownloadingProcessor;
    private MavenProjectsProcessor myPostProcessor;
    private MavenMergingUpdateQueue myImportingQueue;
    private final Object myImportingDataLock = new Object();
    private final Map<MavenProject, MavenProjectChanges> myProjectsToImport = new THashMap();
    private boolean myImportModuleGroupsRequired = false;
    private MavenMergingUpdateQueue mySchedulesQueue;
    private final EventDispatcher<MavenProjectsTree.Listener> myProjectsTreeDispatcher = EventDispatcher.create(MavenProjectsTree.Listener.class);
    private final List<Listener> myManagerListeners = ContainerUtil.createEmptyCOWList();

    public static MavenProjectsManager getInstance(Project p) {
        return (MavenProjectsManager)((Object)p.getComponent(MavenProjectsManager.class));
    }

    public MavenProjectsManager(Project project) {
        super(project);
    }

    public MavenProjectsManagerState getState() {
        if (this.isInitialized()) {
            this.applyTreeToState();
        }
        return this.myState;
    }

    public void loadState(MavenProjectsManagerState state) {
        this.myState = state;
        if (this.isInitialized()) {
            this.applyStateToTree();
            this.scheduleUpdateAllProjects(false);
        }
    }

    public MavenGeneralSettings getGeneralSettings() {
        return this.getWorkspaceSettings().generalSettings;
    }

    public MavenImportingSettings getImportingSettings() {
        return this.getWorkspaceSettings().importingSettings;
    }

    private MavenWorkspaceSettings getWorkspaceSettings() {
        return MavenWorkspaceSettingsComponent.getInstance(this.myProject).getState();
    }

    public File getLocalRepository() {
        return this.getGeneralSettings().getEffectiveLocalRepository();
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        StartupManagerEx.getInstanceEx((Project)this.myProject).registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                boolean wasMavenized;
                boolean bl = wasMavenized = !((MavenProjectsManager)MavenProjectsManager.this).myState.originalFiles.isEmpty();
                if (!wasMavenized) {
                    return;
                }
                MavenProjectsManager.this.initMavenized();
            }
        });
    }

    private void initMavenized() {
        this.doInit(false);
    }

    private void initNew(List<VirtualFile> files, List<String> explicitProfiles) {
        this.myState.originalFiles = MavenUtil.collectPaths(files);
        this.myState.activeProfiles = explicitProfiles;
        this.doInit(true);
    }

    public void initForTests() {
        this.doInit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit(final boolean isNew) {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            this.initProjectsTree(!isNew);
            this.initWorkers();
            this.listenForSettingsChanges();
            this.listenForProjectsTreeChanges();
            MavenUtil.runWhenInitialized(this.myProject, (Runnable)new DumbAwareRunnable(){

                public void run() {
                    if (!MavenProjectsManager.this.isUnitTestMode()) {
                        MavenProjectsManager.this.fireActivated();
                        MavenProjectsManager.this.listenForExternalChanges();
                    }
                    MavenProjectsManager.this.scheduleUpdateAllProjects(isNew);
                }
            });
        }
    }

    private void initProjectsTree(boolean tryToLoadExisting) {
        if (tryToLoadExisting) {
            File file = this.getProjectsTreeFile();
            try {
                if (file.exists()) {
                    this.myProjectsTree = MavenProjectsTree.read(file);
                }
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        if (this.myProjectsTree == null) {
            this.myProjectsTree = new MavenProjectsTree();
        }
        this.applyStateToTree();
        this.myProjectsTree.addListener((MavenProjectsTree.Listener)this.myProjectsTreeDispatcher.getMulticaster());
    }

    private void applyTreeToState() {
        this.myState.originalFiles = this.myProjectsTree.getManagedFilesPaths();
        this.myState.activeProfiles = new ArrayList<String>(this.myProjectsTree.getExplicitProfiles());
        this.myState.ignoredFiles = new THashSet(this.myProjectsTree.getIgnoredFilesPaths());
        this.myState.ignoredPathMasks = this.myProjectsTree.getIgnoredFilesPatterns();
    }

    private void applyStateToTree() {
        this.myProjectsTree.resetManagedFilesPathsAndProfiles(this.myState.originalFiles, this.myState.activeProfiles);
        this.myProjectsTree.setIgnoredFilesPaths(new ArrayList<String>(this.myState.ignoredFiles));
        this.myProjectsTree.setIgnoredFilesPatterns(this.myState.ignoredPathMasks);
    }

    public void save() {
        if (this.myProjectsTree != null) {
            try {
                this.myProjectsTree.save(this.getProjectsTreeFile());
            }
            catch (IOException e) {
                MavenLog.LOG.error((Throwable)e);
            }
        }
    }

    private File getProjectsTreeFile() {
        File file = new File(MavenProjectsManager.getProjectsTreesDir(), this.myProject.getLocationHash() + "/tree.dat");
        file.getParentFile().mkdirs();
        return file;
    }

    private static File getProjectsTreesDir() {
        return MavenUtil.getPluginSystemDir("Projects");
    }

    private void initWorkers() {
        this.myEmbeddersManager = new MavenEmbeddersManager(this.getGeneralSettings());
        this.myReadingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.reading", new Object[0]), false, this.myEmbeddersManager);
        this.myResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.resolving", new Object[0]), true, this.myEmbeddersManager);
        this.myPluginsResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.downloading.plugins", new Object[0]), true, this.myEmbeddersManager);
        this.myFoldersResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.updating.folders", new Object[0]), true, this.myEmbeddersManager);
        this.myArtifactsDownloadingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.downloading", new Object[0]), true, this.myEmbeddersManager);
        this.myPostProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.post.processing", new Object[0]), true, this.myEmbeddersManager);
        this.myWatcher = new MavenProjectsManagerWatcher(this.myProject, this.myProjectsTree, this.getGeneralSettings(), this.myReadingProcessor, this.myEmbeddersManager);
        this.myImportingQueue = new MavenMergingUpdateQueue(this.getComponentName() + ": Importing queue", 1000, !this.isUnitTestMode(), (Disposable)this.myProject);
        this.myImportingQueue.setPassThrough(false);
        this.myImportingQueue.makeUserAware(this.myProject);
        this.myImportingQueue.makeDumbAware(this.myProject);
        this.myImportingQueue.makeModalAware(this.myProject);
        this.mySchedulesQueue = new MavenMergingUpdateQueue(this.getComponentName() + ": Schedules queue", 500, !this.isUnitTestMode(), (Disposable)this.myProject);
        this.mySchedulesQueue.setPassThrough(false);
    }

    private void listenForSettingsChanges() {
        this.getImportingSettings().addListener(new MavenImportingSettings.Listener(){

            @Override
            public void autoImportChanged() {
                MavenProjectsManager.this.scheduleImportSettings();
            }

            @Override
            public void createModuleGroupsChanged() {
                MavenProjectsManager.this.scheduleImportSettings(true);
            }

            @Override
            public void createModuleForAggregatorsChanged() {
                MavenProjectsManager.this.scheduleImportSettings();
            }
        });
    }

    private void listenForProjectsTreeChanges() {
        this.myProjectsTree.addListener(new MavenProjectsTree.ListenerAdapter(){

            @Override
            public void projectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, Object message) {
                if (message instanceof MavenProjectImporter) {
                    return;
                }
                MavenProjectsManager.this.scheduleImport(false);
            }

            @Override
            public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted, Object message) {
                MavenProjectsManager.this.myEmbeddersManager.clearCaches();
                MavenProjectsManager.this.unscheduleAllTasks(deleted);
                List<MavenProject> updatedProjects = MavenUtil.collectFirsts(updated);
                ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>(updated);
                for (MavenProject each : updatedProjects) {
                    for (MavenProject eachDependent : MavenProjectsManager.this.myProjectsTree.getDependentProjects(each)) {
                        toImport.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)eachDependent, (Object)MavenProjectChanges.DEPENDENCIES));
                    }
                }
                THashSet toResolve = new THashSet(updatedProjects);
                for (MavenProject each : ContainerUtil.concat(updatedProjects, deleted)) {
                    toResolve.addAll(MavenProjectsManager.this.myProjectsTree.getDependentProjects(each));
                }
                Iterator it = toResolve.iterator();
                while (it.hasNext()) {
                    MavenProject each;
                    each = (MavenProject)it.next();
                    if (!each.hasReadingProblems()) continue;
                    it.remove();
                }
                if (this.haveChanges(toImport) || !deleted.isEmpty()) {
                    MavenProjectsManager.this.scheduleImport(toImport, message == FORCE_IMPORT_MESSAGE);
                }
                MavenProjectsManager.this.scheduleResolve((Collection)toResolve, message == FORCE_IMPORT_MESSAGE);
            }

            private boolean haveChanges(List<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
                for (MavenProjectChanges each : MavenUtil.collectSeconds(projectsWithChanges)) {
                    if (!each.hasChanges()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, org.apache.maven.project.MavenProject nativeMavenProject, Object message) {
                if (this.shouldScheduleProject(projectWithChanges)) {
                    if (((MavenProject)projectWithChanges.first).hasUnresolvedPlugins()) {
                        MavenProjectsManager.this.schedulePluginsResolving((MavenProject)projectWithChanges.first, nativeMavenProject);
                    }
                    MavenProjectsManager.this.scheduleArtifactsDownloading(Collections.singleton(projectWithChanges.first), null, MavenProjectsManager.this.getImportingSettings().isDownloadSourcesAutomatically(), MavenProjectsManager.this.getImportingSettings().isDownloadDocsAutomatically(), null);
                    MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)projectWithChanges);
                }
                this.processMessage(message);
            }

            @Override
            public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, Object message) {
                if (this.shouldScheduleProject(projectWithChanges)) {
                    MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)projectWithChanges);
                }
                this.processMessage(message);
            }

            private boolean shouldScheduleProject(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                return !((MavenProject)projectWithChanges.first).hasReadingProblems() && ((MavenProjectChanges)projectWithChanges.second).hasChanges();
            }

            private void processMessage(Object message) {
                if (MavenProjectsManager.this.getScheduledProjectsCount() == 0) {
                    return;
                }
                if (message == SCHEDULE_IMPORT_MESSAGE) {
                    MavenProjectsManager.this.scheduleImport(false);
                } else if (message == FORCE_IMPORT_MESSAGE) {
                    MavenProjectsManager.this.scheduleImport(true);
                }
            }
        });
    }

    public void listenForExternalChanges() {
        this.myWatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.isInitialized.getAndSet(false)) {
                return;
            }
            Disposer.dispose((Disposable)this.mySchedulesQueue);
            Disposer.dispose((Disposable)this.myImportingQueue);
            this.myWatcher.stop();
            this.myReadingProcessor.stop();
            this.myResolvingProcessor.stop();
            this.myPluginsResolvingProcessor.stop();
            this.myFoldersResolvingProcessor.stop();
            this.myArtifactsDownloadingProcessor.stop();
            this.myPostProcessor.stop();
            this.myEmbeddersManager.release();
            if (this.isUnitTestMode()) {
                FileUtil.delete((File)MavenProjectsManager.getProjectsTreesDir());
            }
        }
    }

    public MavenEmbeddersManager getEmbeddersManagerInTests() {
        return this.myEmbeddersManager;
    }

    private boolean isInitialized() {
        return this.isInitialized.get();
    }

    public boolean isMavenizedProject() {
        return this.isInitialized();
    }

    public boolean isMavenizedModule(final Module m) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return "true".equals(m.getOptionValue(MavenProjectsManager.this.getMavenizedModuleOptionName()));
            }
        });
    }

    public void setMavenizedModules(Collection<Module> modules, boolean mavenized) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (Module m : modules) {
            if (mavenized) {
                m.setOption(this.getMavenizedModuleOptionName(), "true");
                continue;
            }
            m.clearOption(this.getMavenizedModuleOptionName());
        }
    }

    private String getMavenizedModuleOptionName() {
        return this.getComponentName() + ".isMavenModule";
    }

    public void resetManagedFilesAndProfilesInTests(List<VirtualFile> files, List<String> profiles) {
        this.myWatcher.resetManagedFilesAndProfilesInTests(files, profiles);
    }

    public void addManagedFilesWithProfiles(List<VirtualFile> files, List<String> profiles) {
        if (!this.isInitialized()) {
            this.initNew(files, profiles);
        } else {
            this.myWatcher.addManagedFilesWithProfiles(files, profiles);
        }
    }

    public void addManagedFiles(List<VirtualFile> files) {
        this.addManagedFilesWithProfiles(files, Collections.<String>emptyList());
    }

    public void removeManagedFiles(List<VirtualFile> files) {
        this.myWatcher.removeManagedFiles(files);
    }

    public boolean isManagedFile(VirtualFile f) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isManagedFile(f);
    }

    public Collection<String> getExplicitProfiles() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getExplicitProfiles();
    }

    public void setExplicitProfiles(Collection<String> profiles) {
        this.myWatcher.setExplicitProfiles(profiles);
    }

    public Collection<String> getAvailableProfiles() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getAvailableProfiles();
    }

    public Collection<Pair<String, MavenProfileState>> getProfilesWithStates() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getProfilesWithStates();
    }

    public boolean hasProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.hasProjects();
    }

    public List<MavenProject> getProjects() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getProjects();
    }

    public List<MavenProject> getNonIgnoredProjects() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getNonIgnoredProjects();
    }

    public List<VirtualFile> getProjectsFiles() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getProjectsFiles();
    }

    public MavenProject findProject(VirtualFile f) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(f);
    }

    public MavenProject findProject(MavenId id) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(id);
    }

    public MavenProject findProject(MavenArtifact artifact) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(artifact);
    }

    public MavenProject findProject(Module module) {
        VirtualFile f = MavenProjectsManager.findPomFile(module, new MavenModelsProvider(){

            @Override
            public Module[] getModules() {
                throw new UnsupportedOperationException();
            }

            @Override
            public VirtualFile[] getContentRoots(Module module) {
                return ModuleRootManager.getInstance((Module)module).getContentRoots();
            }
        });
        return f == null ? null : this.findProject(f);
    }

    @Nullable
    public Module findModule(MavenProject project) {
        if (!this.isInitialized()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(project.getFile());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Set<MavenProject> findInheritors(@Nullable MavenProject parent) {
        Set<MavenProject> set;
        if (parent == null || !this.isInitialized()) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenProjectsManager.findInheritors must not return null");
            return set;
        }
        set = this.myProjectsTree.findInheritors(parent);
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenProjectsManager.findInheritors must not return null");
    }

    public MavenProject findContainingProject(VirtualFile file) {
        if (!this.isInitialized()) {
            return null;
        }
        Module module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
        return module == null ? null : this.findProject(module);
    }

    private static VirtualFile findPomFile(Module module, MavenModelsProvider modelsProvider) {
        for (VirtualFile root : modelsProvider.getContentRoots(module)) {
            VirtualFile virtualFile = root.findChild("pom.xml");
            if (virtualFile == null) continue;
            return virtualFile;
        }
        return null;
    }

    public MavenProject findAggregator(MavenProject module) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findAggregator(module);
    }

    public List<MavenProject> getModules(MavenProject aggregator) {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getModules(aggregator);
    }

    public List<String> getIgnoredFilesPaths() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getIgnoredFilesPaths();
    }

    public void setIgnoredFilesPaths(List<String> paths) {
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPaths(paths);
    }

    public boolean getIgnoredState(MavenProject project) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.getIgnoredState(project);
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored) {
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredState(projects, ignored);
    }

    public List<String> getIgnoredFilesPatterns() {
        if (!this.isInitialized()) {
            return Collections.emptyList();
        }
        return this.myProjectsTree.getIgnoredFilesPatterns();
    }

    public void setIgnoredFilesPatterns(List<String> patterns) {
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPatterns(patterns);
    }

    public boolean isIgnored(MavenProject project) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isIgnored(project);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        THashSet result = new THashSet();
        for (MavenProject each : this.getProjects()) {
            for (MavenRemoteRepository eachRepository : each.getRemoteRepositories()) {
                result.add(eachRepository);
            }
        }
        return result;
    }

    public MavenProjectsTree getProjectsTreeForTests() {
        return this.myProjectsTree;
    }

    private void scheduleUpdateAllProjects(boolean forceImport) {
        this.doScheduleUpdateProjects(null, false, forceImport);
    }

    public void forceUpdateProjects(Collection<MavenProject> projects) {
        this.doScheduleUpdateProjects(projects, true, true);
    }

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles() {
        if (!this.isMavenizedProject()) {
            this.addManagedFiles(this.collectAllAvailablePomFiles());
        }
        this.doScheduleUpdateProjects(null, true, true);
    }

    private void doScheduleUpdateProjects(final Collection<MavenProject> projects, final boolean force, final boolean forceImport) {
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)new DumbAwareRunnable(){

            public void run() {
                if (projects == null) {
                    MavenProjectsManager.this.myWatcher.scheduleUpdateAll(force, forceImport);
                } else {
                    MavenProjectsManager.this.myWatcher.scheduleUpdate(MavenUtil.collectFiles(projects), Collections.EMPTY_LIST, force, forceImport);
                }
            }
        });
    }

    private void scheduleResolve(final Collection<MavenProject> projects, final boolean forceImport) {
        this.runWhenFullyOpen(new Runnable(){

            @Override
            public void run() {
                Iterator it = projects.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    Object message = it.hasNext() ? null : (forceImport ? FORCE_IMPORT_MESSAGE : SCHEDULE_IMPORT_MESSAGE);
                    MavenProjectsManager.this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorResolvingTask(each, MavenProjectsManager.this.myProjectsTree, MavenProjectsManager.this.getGeneralSettings(), message));
                }
            }
        });
    }

    public void scheduleResolveInTests(Collection<MavenProject> projects) {
        this.scheduleResolve(projects, false);
    }

    public void scheduleResolveAllInTests() {
        this.scheduleResolve(this.getProjects(), false);
    }

    public void scheduleFoldersResolving(final Collection<MavenProject> projects) {
        this.runWhenFullyOpen(new Runnable(){

            @Override
            public void run() {
                Iterator it = projects.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    Object message = it.hasNext() ? null : FORCE_IMPORT_MESSAGE;
                    MavenProjectsManager.this.myFoldersResolvingProcessor.scheduleTask(new MavenProjectsProcessorFoldersResolvingTask(each, MavenProjectsManager.this.getGeneralSettings(), MavenProjectsManager.this.getImportingSettings(), MavenProjectsManager.this.myProjectsTree, message));
                }
            }
        });
    }

    public void scheduleFoldersResolvingForAllProjects() {
        this.scheduleFoldersResolving(this.getProjects());
    }

    private void schedulePluginsResolving(final MavenProject project, final org.apache.maven.project.MavenProject nativeMavenProject) {
        this.runWhenFullyOpen(new Runnable(){

            @Override
            public void run() {
                MavenProjectsManager.this.myPluginsResolvingProcessor.scheduleTask(new MavenProjectsProcessorPluginsResolvingTask(project, nativeMavenProject, MavenProjectsManager.this.myProjectsTree));
            }
        });
    }

    public void scheduleArtifactsDownloading(final Collection<MavenProject> projects, final @Nullable Collection<MavenArtifact> artifacts, final boolean sources, final boolean docs, final @Nullable AsyncResult<MavenArtifactDownloader.DownloadResult> result) {
        if (!sources && !docs) {
            return;
        }
        this.runWhenFullyOpen(new Runnable(){

            @Override
            public void run() {
                MavenProjectsManager.this.myArtifactsDownloadingProcessor.scheduleTask(new MavenProjectsProcessorArtifactsDownloadingTask(projects, artifacts, MavenProjectsManager.this.myProjectsTree, sources, docs, (AsyncResult<MavenArtifactDownloader.DownloadResult>)result));
            }
        });
    }

    private void scheduleImport(List<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges, boolean forceImport) {
        this.scheduleForNextImport(projectsWithChanges);
        this.scheduleImport(forceImport);
    }

    private void scheduleImportSettings() {
        this.scheduleImportSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImportSettings(boolean importModuleGroupsRequired) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        }
        this.scheduleImport(false);
    }

    private void scheduleImport(final boolean forceImport) {
        this.runWhenFullyOpen(new Runnable(){

            @Override
            public void run() {
                final boolean autoImport = MavenProjectsManager.this.getImportingSettings().isImportAutomatically();
                MavenProjectsManager.this.mySchedulesQueue.queue(new Update(new Object()){

                    public void run() {
                        if (autoImport || forceImport) {
                            MavenProjectsManager.this.myImportingQueue.activate();
                        } else {
                            MavenProjectsManager.this.myImportingQueue.deactivate();
                        }
                    }
                });
                MavenProjectsManager.this.myImportingQueue.queue(new Update((Object)MavenProjectsManager.this){

                    public void run() {
                        MavenProjectsManager.this.importProjects();
                        if (!autoImport) {
                            MavenProjectsManager.this.myImportingQueue.deactivate();
                        }
                    }
                });
                if (!forceImport) {
                    MavenProjectsManager.this.fireScheduledImportsChanged();
                }
            }
        });
    }

    public void scheduleImportInTests(List<VirtualFile> projectFiles) {
        ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>();
        for (VirtualFile each : projectFiles) {
            MavenProject project = this.findProject(each);
            if (project == null) continue;
            toImport.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project, (Object)MavenProjectChanges.ALL));
        }
        this.scheduleImport(toImport, false);
    }

    private void scheduleForNextImport(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        this.scheduleForNextImport(Collections.singletonList(projectWithChanges));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForNextImport(List<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            for (Pair<MavenProject, MavenProjectChanges> each : projectsWithChanges) {
                MavenProjectChanges changes = ((MavenProjectChanges)each.second).mergedWith(this.myProjectsToImport.get(each.first));
                this.myProjectsToImport.put((MavenProject)each.first, changes);
            }
        }
    }

    public boolean hasScheduledImports() {
        if (!this.isInitialized()) {
            return false;
        }
        return !this.myImportingQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledProjectsCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        Object object = this.myImportingDataLock;
        synchronized (object) {
            return this.myProjectsToImport.size();
        }
    }

    public void performScheduledImport() {
        this.performScheduledImport(true);
    }

    public void performScheduledImport(final boolean force) {
        if (!this.isInitialized()) {
            return;
        }
        this.runWhenFullyOpen(new Runnable(){

            @Override
            public void run() {
                MavenProjectsManager.this.mySchedulesQueue.flush(false);
                if (!force && !MavenProjectsManager.this.myImportingQueue.isActive()) {
                    return;
                }
                MavenProjectsManager.this.myImportingQueue.flush(false);
            }
        });
    }

    private void runWhenFullyOpen(final Runnable runnable) {
        if (!this.isInitialized()) {
            return;
        }
        if (this.isNoBackgroundMode()) {
            runnable.run();
            return;
        }
        final Ref wrapper = new Ref();
        wrapper.set((Object)new Runnable(){

            @Override
            public void run() {
                if (!StartupManagerEx.getInstanceEx((Project)MavenProjectsManager.this.myProject).postStartupActivityPassed()) {
                    MavenProjectsManager.this.mySchedulesQueue.queue(new Update(runnable){

                        public void run() {
                            ((Runnable)wrapper.get()).run();
                        }
                    });
                    return;
                }
                runnable.run();
            }
        });
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)wrapper.get());
    }

    private void schedulePostImportTasts(List<MavenProjectsProcessorTask> postTasks) {
        for (MavenProjectsProcessorTask each : postTasks) {
            this.myPostProcessor.scheduleTask(each);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleAllTasks(List<MavenProject> projects) {
        for (MavenProject each : projects) {
            MavenProjectsProcessorEmptyTask dummyTask = new MavenProjectsProcessorEmptyTask(each);
            Object object = this.myImportingDataLock;
            synchronized (object) {
                this.myProjectsToImport.remove(each);
            }
            this.myResolvingProcessor.removeTask(dummyTask);
            this.myPluginsResolvingProcessor.removeTask(dummyTask);
            this.myFoldersResolvingProcessor.removeTask(dummyTask);
            this.myPostProcessor.removeTask(dummyTask);
        }
    }

    public void unscheduleAllTasksInTests() {
        this.unscheduleAllTasks(this.getProjects());
    }

    public void waitForReadingCompletion() {
        this.waitForTasksCompletion(null);
    }

    public void waitForResolvingCompletion() {
        this.waitForTasksCompletion(this.myResolvingProcessor);
    }

    public void waitForFoldersResolvingCompletion() {
        this.waitForTasksCompletion(this.myFoldersResolvingProcessor);
    }

    public void waitForPluginsResolvingCompletion() {
        this.waitForTasksCompletion(this.myPluginsResolvingProcessor);
    }

    public void waitForArtifactsDownloadingCompletion() {
        this.waitForTasksCompletion(this.myArtifactsDownloadingProcessor);
    }

    public void waitForPostImportTasksCompletion() {
        this.myPostProcessor.waitForCompletion();
    }

    private void waitForTasksCompletion(MavenProjectsProcessor processor) {
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myReadingProcessor.waitForCompletion();
        if (processor != null) {
            processor.waitForCompletion();
        }
    }

    public void updateProjectTargetFolders() {
        this.updateProjectFolders(true);
    }

    private void updateProjectFolders(final boolean targetFoldersOnly) {
        MavenUtil.invokeLater(this.myProject, new Runnable(){

            @Override
            public void run() {
                MavenFoldersImporter.updateProjectFolders(MavenProjectsManager.this.myProject, targetFoldersOnly);
                VirtualFileManager.getInstance().refresh(false);
            }
        });
    }

    public List<Module> importProjects() {
        return this.importProjects(new MavenDefaultModifiableModelsProvider(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Module> importProjects(final MavenModifiableModelsProvider modelsProvider) {
        boolean importModuleGroupsRequired;
        THashMap projectsToImportWithChanges;
        Object object = this.myImportingDataLock;
        synchronized (object) {
            projectsToImportWithChanges = new THashMap(this.myProjectsToImport);
            this.myProjectsToImport.clear();
            importModuleGroupsRequired = this.myImportModuleGroupsRequired;
        }
        this.fireScheduledImportsChanged();
        final Ref importer = new Ref();
        Ref postTasks = new Ref();
        final Runnable r = new Runnable((Map)projectsToImportWithChanges, importModuleGroupsRequired, postTasks){
            final /* synthetic */ Map val$projectsToImportWithChanges;
            final /* synthetic */ boolean val$importModuleGroupsRequired;
            final /* synthetic */ Ref val$postTasks;
            {
                this.val$projectsToImportWithChanges = map;
                this.val$importModuleGroupsRequired = bl;
                this.val$postTasks = ref2;
            }

            @Override
            public void run() {
                importer.set((Object)new MavenProjectImporter(MavenProjectsManager.this.myProject, MavenProjectsManager.this.myProjectsTree, MavenProjectsManager.this.getFileToModuleMapping(modelsProvider), this.val$projectsToImportWithChanges, this.val$importModuleGroupsRequired, modelsProvider, MavenProjectsManager.this.getImportingSettings()));
                this.val$postTasks.set(((MavenProjectImporter)importer.get()).importProject());
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            MavenUtil.runInBackground(this.myProject, ProjectBundle.message("maven.project.importing", new Object[0]), false, new MavenTask(){

                @Override
                public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    r.run();
                }
            }).waitFor();
        }
        VirtualFileManager.getInstance().refresh(this.isNormalProject());
        this.schedulePostImportTasts((List)postTasks.get());
        this.myImportingQueue.restartTimer();
        return ((MavenProjectImporter)importer.get()).getCreatedModules();
    }

    private Map<VirtualFile, Module> getFileToModuleMapping(MavenModelsProvider modelsProvider) {
        THashMap result = new THashMap();
        for (Module each : modelsProvider.getModules()) {
            VirtualFile f = MavenProjectsManager.findPomFile(each, modelsProvider);
            if (f == null) continue;
            result.put(f, each);
        }
        return result;
    }

    private List<VirtualFile> collectAllAvailablePomFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.getFileToModuleMapping(new MavenDefaultModelsProvider(this.myProject)).keySet());
        VirtualFile pom = this.myProject.getBaseDir().findChild("pom.xml");
        if (pom != null) {
            result.add(pom);
        }
        return result;
    }

    public MavenDomDependency addOverridenDependency(MavenProject mavenProject, MavenId id) {
        return this.addDependency(mavenProject, id, true);
    }

    public MavenDomDependency addDependency(MavenProject mavenProject, MavenId id) {
        return this.addDependency(mavenProject, id, false);
    }

    public MavenDomDependency addDependency(final MavenProject mavenProject, final MavenId id, final boolean overriden) {
        final MavenArtifact[] artifact = new MavenArtifact[1];
        try {
            MavenUtil.run(this.myProject, "Downloading dependency...", new MavenTask(){

                @Override
                public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    artifact[0] = MavenProjectsManager.this.myProjectsTree.downloadArtifact(mavenProject, id, MavenProjectsManager.this.myEmbeddersManager, new SoutMavenConsole(), indicator);
                }
            });
        }
        catch (MavenProcessCanceledException ignore) {
            return null;
        }
        VirtualFile file = mavenProject.getFile();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        MavenDomDependency result = (MavenDomDependency)new WriteCommandAction<MavenDomDependency>(this.myProject, "Add Maven Dependency", new PsiFile[]{psiFile}){

            protected void run(Result<MavenDomDependency> result) throws Throwable {
                MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(MavenProjectsManager.this.myProject, mavenProject.getFile());
                MavenDomDependency domDependency = MavenDomUtil.createDomDependency(model, artifact[0], MavenProjectsManager.this.getEditor(), overriden);
                mavenProject.addDependency(artifact[0]);
                result.setResult((Object)domDependency);
            }
        }.execute().getResultObject();
        this.scheduleImport(Collections.singletonList(Pair.create((Object)mavenProject, (Object)MavenProjectChanges.DEPENDENCIES)), true);
        return result;
    }

    @Nullable
    private Editor getEditor() {
        return FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
    }

    public void addManagerListener(Listener listener) {
        this.myManagerListeners.add(listener);
    }

    public void addProjectsTreeListener(MavenProjectsTree.Listener listener) {
        this.myProjectsTreeDispatcher.addListener((EventListener)listener);
    }

    public void fireActivatedInTests() {
        this.fireActivated();
    }

    private void fireActivated() {
        for (Listener each : this.myManagerListeners) {
            each.activated();
        }
    }

    private void fireScheduledImportsChanged() {
        for (Listener each : this.myManagerListeners) {
            each.scheduledImportsChanged();
        }
    }

    public static interface Listener {
        public void activated();

        public void scheduledImportsChanged();
    }
}

