/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.Serializable;

public class MavenProjectProblem
implements Serializable {
    private String myUrl;
    private String myDescription;
    private ProblemType myType;

    protected MavenProjectProblem() {
    }

    public MavenProjectProblem(VirtualFile file, String description, ProblemType type) {
        this.myUrl = file.getUrl();
        this.myDescription = description;
        this.myType = type;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public ProblemType getType() {
        return this.myType;
    }

    public VirtualFile findFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
    }

    public String toString() {
        return (Object)((Object)this.myType) + ":" + this.myDescription + ":" + this.myUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenProjectProblem that = (MavenProjectProblem)o;
        if (!this.myDescription.equals(that.myDescription)) {
            return false;
        }
        if (this.myType != that.myType) {
            return false;
        }
        return this.myUrl.equals(that.myUrl);
    }

    public int hashCode() {
        int result = this.myUrl.hashCode();
        result = 31 * result + this.myDescription.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public static enum ProblemType {
        SYNTAX,
        STRUCTURE,
        DEPENDENCY,
        PARENT,
        SETTINGS_OR_PROFILES;

    }
}

