/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenArtifactSearcher;
import org.jetbrains.idea.maven.indices.MavenClassSearchResult;
import org.jetbrains.idea.maven.indices.MavenClassSearcher;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.sonatype.nexus.index.ArtifactInfo;

public class MavenArtifactSearchPanel
extends JPanel {
    private final Project myProject;
    private final boolean myClassMode;
    private final Listener myListener;
    private JTextField mySearchField;
    private Tree myResultList;
    private final Alarm myAlarm;

    public MavenArtifactSearchPanel(Project project, String initialText, boolean classMode, Listener listener, Disposable parent) {
        this.myProject = project;
        this.myClassMode = classMode;
        this.myListener = listener;
        this.initComponents(initialText);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, parent);
    }

    public JTextField getSearchField() {
        return this.mySearchField;
    }

    private void initComponents(String initialText) {
        this.mySearchField = new JTextField(initialText);
        this.myResultList = new Tree();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySearchField, "North");
        this.add((Component)new JScrollPane((Component)this.myResultList), "Center");
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MavenArtifactSearchPanel.this.scheduleSearch();
            }
        });
        this.myResultList.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (MavenArtifactSearchPanel.this.myAlarm.getActiveRequestCount() > 0) {
                    return;
                }
                boolean hasSelection = !MavenArtifactSearchPanel.this.myResultList.isSelectionEmpty();
                MavenArtifactSearchPanel.this.myListener.canSelectStateChanged(MavenArtifactSearchPanel.this, hasSelection);
            }
        });
        this.mySearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object action = this.getAction(e, (JComponent)MavenArtifactSearchPanel.this.myResultList);
                if ("selectNext".equals(action)) {
                    TreeUtil.moveDown((JTree)MavenArtifactSearchPanel.this.myResultList);
                } else if ("selectPrevious".equals(action)) {
                    TreeUtil.moveUp((JTree)MavenArtifactSearchPanel.this.myResultList);
                } else if ("scrollUpChangeSelection".equals(action)) {
                    TreeUtil.movePageUp((JTree)MavenArtifactSearchPanel.this.myResultList);
                } else if ("scrollDownChangeSelection".equals(action)) {
                    TreeUtil.movePageDown((JTree)MavenArtifactSearchPanel.this.myResultList);
                }
            }

            private Object getAction(KeyEvent e, JComponent comp) {
                KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                return comp.getInputMap().get(stroke);
            }
        });
        this.myResultList.setRootVisible(false);
        this.myResultList.setShowsRootHandles(true);
        this.myResultList.setModel(null);
        this.myResultList.setFocusable(false);
        this.myResultList.setCellRenderer((TreeCellRenderer)(this.myClassMode ? new MyClassCellRenderer() : new MyArtifactCellRenderer()));
        this.myResultList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object sel;
                if (e.getClickCount() == 2 && (sel = MavenArtifactSearchPanel.this.myResultList.getLastSelectedPathComponent()) != null && MavenArtifactSearchPanel.this.myResultList.getModel().isLeaf(sel)) {
                    MavenArtifactSearchPanel.this.myListener.doubleClicked();
                }
                if (!MavenArtifactSearchPanel.this.mySearchField.hasFocus()) {
                    MavenArtifactSearchPanel.this.mySearchField.requestFocus();
                }
            }
        });
    }

    public void scheduleSearch() {
        this.myListener.canSelectStateChanged(this, false);
        final String text = this.mySearchField.getText();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    MavenArtifactSearchPanel.this.doSearch(text);
                }
                catch (Throwable e) {
                    MavenLog.LOG.warn(e);
                }
            }
        }, 500);
    }

    private void doSearch(String searchText) {
        MavenSearcher searcher = this.myClassMode ? new MavenClassSearcher() : new MavenArtifactSearcher();
        List result = searcher.search(this.myProject, searchText, 200);
        final MyTreeModel model = new MyTreeModel(result);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MavenArtifactSearchPanel.this.myProject.isDisposed()) {
                    return;
                }
                MavenArtifactSearchPanel.this.myResultList.setModel(model);
                MavenArtifactSearchPanel.this.myResultList.setSelectionRow(0);
            }
        });
    }

    public MavenId getResult() {
        Object sel = this.myResultList.getLastSelectedPathComponent();
        ArtifactInfo info = sel instanceof ArtifactInfo ? (ArtifactInfo)sel : ((MavenArtifactSearchResult)sel).versions.get(0);
        return new MavenId(info.groupId, info.artifactId, info.version);
    }

    public static interface Listener {
        public void doubleClicked();

        public void canSelectStateChanged(MavenArtifactSearchPanel var1, boolean var2);
    }

    private static class MyClassCellRenderer
    extends MyArtifactCellRenderer {
        private MyClassCellRenderer() {
        }

        @Override
        protected void formatSearchResult(JTree tree, MavenArtifactSearchResult searchResult) {
            MavenClassSearchResult classResult = (MavenClassSearchResult)searchResult;
            ArtifactInfo info = searchResult.versions.get(0);
            this.myLeftComponent.append(classResult.className, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.myLeftComponent.append(" (" + classResult.packageName + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.myRightComponent.append(" " + info.groupId + ":" + info.artifactId, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private static class MyArtifactCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected SimpleColoredComponent myLeftComponent = new SimpleColoredComponent();
        protected SimpleColoredComponent myRightComponent = new SimpleColoredComponent();

        private MyArtifactCellRenderer() {
            this.setLayout(new BorderLayout());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.myLeftComponent.clear();
            this.myRightComponent.clear();
            if (UIUtil.isUnderQuaquaLookAndFeel()) {
                this.setBackground(selected ? UIUtil.getTreeSelectionBackground() : null);
            } else if (selected) {
                this.setBackground(UIUtil.getTreeSelectionBackground());
                this.setForeground(UIUtil.getTreeSelectionForeground());
            } else {
                this.setBackground(null);
                this.setForeground(tree.getForeground());
            }
            if (this.getFont() == null) {
                this.setFont(tree.getFont());
            }
            if (value == tree.getModel().getRoot()) {
                this.myLeftComponent.append("Results", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else if (value instanceof MavenArtifactSearchResult) {
                this.formatSearchResult(tree, (MavenArtifactSearchResult)value);
            } else if (value instanceof ArtifactInfo) {
                ArtifactInfo info = (ArtifactInfo)value;
                this.myLeftComponent.append(info.groupId + ":" + info.artifactId + ":" + info.version, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            this.removeAll();
            this.add((Component)this.myLeftComponent, "West");
            JPanel spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            spacer.setBackground(selected ? UIUtil.getTreeSelectionBackground() : tree.getBackground());
            this.add((Component)spacer, "Center");
            this.add((Component)this.myRightComponent, "East");
            return this;
        }

        protected void formatSearchResult(JTree tree, MavenArtifactSearchResult searchResult) {
            ArtifactInfo first = searchResult.versions.get(0);
            ArtifactInfo last = searchResult.versions.get(searchResult.versions.size() - 1);
            this.myLeftComponent.append(first.groupId + ":" + first.artifactId, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.myLeftComponent.append(":" + last.version + "-" + first.version, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private static class MyTreeModel
    implements TreeModel {
        List<? extends MavenArtifactSearchResult> myItems;

        private MyTreeModel(List<? extends MavenArtifactSearchResult> items) {
            this.myItems = items;
        }

        @Override
        public Object getRoot() {
            return this.myItems;
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.getList(parent).get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.getList(parent).size();
        }

        public List getList(Object parent) {
            if (parent == this.myItems) {
                return this.myItems;
            }
            if (parent instanceof MavenArtifactSearchResult) {
                return ((MavenArtifactSearchResult)parent).versions;
            }
            return null;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getList(node) == null;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return this.getList(parent).indexOf(child);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

