/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import org.jetbrains.idea.maven.importing.MavenBaseModifiableModelsProvider;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenUIModifiableModelsProvider
extends MavenBaseModifiableModelsProvider {
    private final ModifiableModuleModel myModel;
    private final ModulesConfigurator myModulesConfigurator;
    private final ModifiableArtifactModel myModifiableArtifactModel;
    private final LibrariesModifiableModel myLibrariesModel;

    public MavenUIModifiableModelsProvider(Project project, ModifiableModuleModel model, ModulesConfigurator modulesConfigurator, ModifiableArtifactModel modifiableArtifactModel) {
        super(project);
        this.myModel = model;
        this.myModulesConfigurator = modulesConfigurator;
        this.myModifiableArtifactModel = modifiableArtifactModel;
        ProjectLibrariesConfigurable configurable = ProjectLibrariesConfigurable.getInstance((Project)project);
        this.myLibrariesModel = (LibrariesModifiableModel)configurable.getModelProvider(true).getModifiableModel();
    }

    @Override
    protected ModifiableArtifactModel doGetArtifactModel() {
        return this.myModifiableArtifactModel;
    }

    @Override
    protected ModifiableModuleModel doGetModuleModel() {
        return this.myModel;
    }

    @Override
    protected ModifiableRootModel doGetRootModel(Module module) {
        return this.myModulesConfigurator.getEditor(module).getModifiableRootModel();
    }

    @Override
    protected ModifiableFacetModel doGetFacetModel(Module module) {
        return (ModifiableFacetModel)this.myModulesConfigurator.getFacetModel(module);
    }

    @Override
    public Library[] getAllLibraries() {
        return this.myLibrariesModel.getLibraries();
    }

    @Override
    public Library getLibraryByName(String name) {
        return this.myLibrariesModel.getLibraryByName(name);
    }

    @Override
    public Library createLibrary(String name) {
        return this.myLibrariesModel.createLibrary(name);
    }

    @Override
    public void removeLibrary(Library library) {
        this.myLibrariesModel.removeLibrary(library);
    }

    @Override
    protected Library.ModifiableModel doGetLibraryModel(Library library) {
        return this.myLibrariesModel.getLibraryModifiableModel(library);
    }

    @Override
    public void commit() {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                MavenUIModifiableModelsProvider.this.processExternalArtifactDependencies();
            }
        });
    }

    @Override
    public void dispose() {
    }

    @Override
    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.defaultModalityState();
    }
}

