/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProfilesModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenResource;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.vfs.MavenPropertiesVirtualFileSystem;

public class MavenDomUtil {
    private static final Pattern XML_TAG_NAME_PATTERN = Pattern.compile("(\\S*)\\[(\\d*)\\]\\z");

    public static boolean isMavenFile(PsiFile file) {
        return MavenDomUtil.isProjectFile(file) || MavenDomUtil.isProfilesFile(file) || MavenDomUtil.isSettingsFile(file);
    }

    public static boolean isProjectFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        return name.equals("pom.xml") || name.endsWith(".pom") || name.equals("pom-4.0.0.xml");
    }

    public static boolean isProfilesFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        return name.equals("profiles.xml");
    }

    public static boolean isSettingsFile(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        return name.equals("settings.xml");
    }

    public static boolean isMavenFile(PsiElement element) {
        return MavenDomUtil.isMavenFile(element.getContainingFile());
    }

    @Nullable
    public static Module findContainingMavenizedModule(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findContainingMavenizedModule must not be null");
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        Project project = psiFile.getProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject()) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = index.getModuleForFile(file);
        if (module == null || !manager.isMavenizedModule(module)) {
            return null;
        }
        return module;
    }

    public static boolean isMavenProperty(PsiElement target) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)target, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        return DomUtil.findDomElement((PsiElement)tag, MavenDomProperties.class) != null;
    }

    public static String calcRelativePath(VirtualFile parent, VirtualFile child) {
        String result = FileUtil.getRelativePath((String)parent.getPath(), (String)child.getPath(), (char)'/');
        if (result == null) {
            MavenLog.LOG.warn("cannot calculate relative path for\nparent: " + parent + "\nchild: " + child);
            result = child.getPath();
        }
        return FileUtil.toSystemIndependentName((String)result);
    }

    public static MavenDomParent updateMavenParent(MavenDomProjectModel mavenModel, MavenProject parentProject) {
        MavenDomParent result = mavenModel.getMavenParent();
        VirtualFile pomFile = DomUtil.getFile((DomElement)mavenModel).getVirtualFile();
        Project project = mavenModel.getXmlElement().getProject();
        MavenId parentId = parentProject.getMavenId();
        result.getGroupId().setStringValue(parentId.getGroupId());
        result.getArtifactId().setStringValue(parentId.getArtifactId());
        result.getVersion().setStringValue(parentId.getVersion());
        if (pomFile.getParent().getParent() != parentProject.getDirectoryFile()) {
            result.getRelativePath().setValue((Object)PsiManager.getInstance((Project)project).findFile(parentProject.getFile()));
        }
        return result;
    }

    public static <T> T getImmediateParent(ConvertContext context, Class<T> clazz) {
        DomElement parentElement = context.getInvocationElement().getParent();
        return (T)(clazz.isInstance(parentElement) ? parentElement : null);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getVirtualFile must not be null");
        }
        XmlFile psiFile = DomUtil.getFile((DomElement)element);
        return MavenDomUtil.getVirtualFile((PsiFile)psiFile);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getVirtualFile must not be null");
        }
        PsiFile psiFile = element.getContainingFile();
        return MavenDomUtil.getVirtualFile(psiFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        psiFile = psiFile.getOriginalFile();
        return psiFile.getVirtualFile();
    }

    @Nullable
    public static MavenProject findProject(@NotNull MavenDomProjectModel projectDom) {
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findProject must not be null");
        }
        XmlElement element = projectDom.getXmlElement();
        if (element == null) {
            return null;
        }
        VirtualFile file = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findProject(file);
    }

    @Nullable
    public static MavenProject findContainingProject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findContainingProject must not be null");
        }
        VirtualFile file = MavenDomUtil.getVirtualFile(element);
        if (file == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findContainingProject(file);
    }

    @Nullable
    public static MavenDomProjectModel getMavenDomProjectModel(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomProjectModel must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomProjectModel must not be null");
        }
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProjectModel.class);
    }

    @Nullable
    public static MavenDomProfiles getMavenDomProfilesModel(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomProfilesModel must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomProfilesModel must not be null");
        }
        MavenDomProfilesModel model = MavenDomUtil.getMavenDomModel(project, file, MavenDomProfilesModel.class);
        if (model != null) {
            return model.getProfiles();
        }
        return MavenDomUtil.getMavenDomModel(project, file, MavenDomProfiles.class);
    }

    @Nullable
    public static <T extends MavenDomElement> T getMavenDomModel(@NotNull Project project, @NotNull VirtualFile file, @NotNull Class<T> clazz) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomModel must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomModel must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomModel must not be null");
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(psiFile, clazz);
    }

    @Nullable
    public static <T extends MavenDomElement> T getMavenDomModel(@NotNull PsiFile file, @NotNull Class<T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomModel must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomModel must not be null");
        }
        DomFileElement<T> fileElement = MavenDomUtil.getMavenDomFile(file, clazz);
        return (T)(fileElement == null ? null : (MavenDomElement)fileElement.getRootElement());
    }

    @Nullable
    private static <T extends MavenDomElement> DomFileElement<T> getMavenDomFile(@NotNull PsiFile file, @NotNull Class<T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomFile must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getMavenDomFile must not be null");
        }
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, clazz);
    }

    @Nullable
    public static XmlTag findTag(@NotNull DomElement domElement, @NotNull String path) {
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findTag must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findTag must not be null");
        }
        List elements = StringUtil.split((String)path, (String)".");
        if (elements.isEmpty()) {
            return null;
        }
        Pair<String, Integer> nameAndIndex = MavenDomUtil.translateTagName((String)elements.get(0));
        String name = (String)nameAndIndex.first;
        Integer index = (Integer)nameAndIndex.second;
        XmlTag result = domElement.getXmlTag();
        if (result == null || !name.equals(result.getName())) {
            return null;
        }
        result = MavenDomUtil.getIndexedTag(result, index);
        for (String each : elements.subList(1, elements.size())) {
            nameAndIndex = MavenDomUtil.translateTagName(each);
            name = (String)nameAndIndex.first;
            index = (Integer)nameAndIndex.second;
            if ((result = result.findFirstSubTag(name)) == null) {
                return null;
            }
            result = MavenDomUtil.getIndexedTag(result, index);
        }
        return result;
    }

    private static Pair<String, Integer> translateTagName(String text) {
        String tagName = text.trim();
        Integer index = null;
        Matcher matcher = XML_TAG_NAME_PATTERN.matcher(tagName);
        if (matcher.find()) {
            tagName = matcher.group(1);
            try {
                index = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return Pair.create((Object)tagName, index);
    }

    private static XmlTag getIndexedTag(XmlTag parent, Integer index) {
        if (index == null) {
            return parent;
        }
        XmlTag[] children = parent.getSubTags();
        if (index < 0 || index >= children.length) {
            return null;
        }
        return children[index];
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getPropertiesFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getPropertiesFile must not be null");
        }
        MavenPropertiesVirtualFileSystem fs = MavenPropertiesVirtualFileSystem.getInstance();
        VirtualFile file = fs.findFileByPath(fileName);
        if (file == null) {
            return null;
        }
        return MavenDomUtil.getPropertiesFile(project, file);
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getPropertiesFile must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getPropertiesFile must not be null");
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof PropertiesFile)) {
            return null;
        }
        return (PropertiesFile)psiFile;
    }

    @Nullable
    public static Property findProperty(@NotNull Project project, @NotNull String fileName, @NotNull String propName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findProperty must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findProperty must not be null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findProperty must not be null");
        }
        PropertiesFile propertiesFile = MavenDomUtil.getPropertiesFile(project, fileName);
        return propertiesFile == null ? null : propertiesFile.findPropertyByKey(propName);
    }

    @Nullable
    public static Property findProperty(@NotNull Project project, @NotNull VirtualFile file, @NotNull String propName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findProperty must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findProperty must not be null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findProperty must not be null");
        }
        PropertiesFile propertiesFile = MavenDomUtil.getPropertiesFile(project, file);
        return propertiesFile == null ? null : propertiesFile.findPropertyByKey(propName);
    }

    @Nullable
    public static PsiElement findPropertyValue(@NotNull Project project, @NotNull VirtualFile file, @NotNull String propName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findPropertyValue must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findPropertyValue must not be null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.findPropertyValue must not be null");
        }
        Property prop = MavenDomUtil.findProperty(project, file, propName);
        return prop == null ? null : prop.getFirstChild().getNextSibling().getNextSibling();
    }

    public static boolean isFiltererResourceFile(PsiElement element) {
        MavenProject project = MavenDomUtil.findContainingProject(element);
        if (project == null) {
            return false;
        }
        VirtualFile file = MavenDomUtil.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        for (MavenResource each : project.getResources()) {
            VirtualFile resourceDir = LocalFileSystem.getInstance().findFileByPath(each.getDirectory());
            if (resourceDir == null || !VfsUtil.isAncestor((VirtualFile)resourceDir, (VirtualFile)file, (boolean)true)) continue;
            return each.isFiltered();
        }
        return false;
    }

    public static List<DomFileElement<MavenDomProjectModel>> collectProjectModels(Project p) {
        return DomService.getInstance().getFileElements(MavenDomProjectModel.class, p, GlobalSearchScope.projectScope((Project)p));
    }

    public static MavenId describe(PsiFile psiFile) {
        MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(psiFile, MavenDomProjectModel.class);
        String groupId = model.getGroupId().getStringValue();
        String artifactId = model.getArtifactId().getStringValue();
        String version = model.getVersion().getStringValue();
        if (groupId == null) {
            groupId = model.getMavenParent().getGroupId().getStringValue();
        }
        if (version == null) {
            version = model.getMavenParent().getVersion().getStringValue();
        }
        return new MavenId(groupId, artifactId, version);
    }

    @NotNull
    public static MavenDomDependency createDomDependency(MavenDomProjectModel model, MavenArtifact mavenArtifact, Editor editor, boolean overriden) {
        MavenDomDependency domDependency = MavenDomUtil.createMavenDomDependency(model, editor);
        domDependency.getGroupId().setStringValue(mavenArtifact.getGroupId());
        domDependency.getArtifactId().setStringValue(mavenArtifact.getArtifactId());
        if (!overriden) {
            domDependency.getVersion().setStringValue(mavenArtifact.getVersion());
        }
        MavenDomDependency mavenDomDependency = domDependency;
        if (mavenDomDependency == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/MavenDomUtil.createDomDependency must not return null");
        }
        return mavenDomDependency;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static MavenDomDependency createMavenDomDependency(@NotNull MavenDomProjectModel model, @Nullable Editor editor) {
        MavenDomDependency mavenDomDependency;
        DomElement element;
        DomCollectionChildDescription childDescription;
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.createMavenDomDependency must not be null");
        }
        MavenDomDependencies dependencies = model.getDependencies();
        int index = MavenDomUtil.getCollectionIndex(dependencies, editor);
        if (index >= 0 && (childDescription = dependencies.getGenericInfo().getCollectionChildDescription("dependency")) != null && (element = childDescription.addValue((DomElement)dependencies, index)) instanceof MavenDomDependency) {
            mavenDomDependency = (MavenDomDependency)element;
            if (mavenDomDependency == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/MavenDomUtil.createMavenDomDependency must not return null");
            return mavenDomDependency;
        }
        mavenDomDependency = dependencies.addDependency();
        if (mavenDomDependency != null) return mavenDomDependency;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/MavenDomUtil.createMavenDomDependency must not return null");
    }

    public static int getCollectionIndex(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor) {
        if (dependencies == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomUtil.getCollectionIndex must not be null");
        }
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            List<MavenDomDependency> dependencyList = dependencies.getDependencies();
            for (int i = 0; i < dependencyList.size(); ++i) {
                MavenDomDependency dependency = dependencyList.get(i);
                XmlElement xmlElement = dependency.getXmlElement();
                if (xmlElement == null || xmlElement.getTextRange().getStartOffset() < offset) continue;
                return i;
            }
        }
        return -1;
    }
}

