/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.integrate.IntegratedSelectedOptionsDialog;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SvnIntegrateChangesActionPerformer
implements SelectBranchPopup.BranchSelectedCallback {
    private final SvnVcs myVcs;
    private final MergerFactory myMergerFactory;
    private final SVNURL myCurrentBranch;

    public SvnIntegrateChangesActionPerformer(Project project, SVNURL currentBranchUrl, MergerFactory mergerFactory) {
        this.myVcs = SvnVcs.getInstance(project);
        this.myCurrentBranch = currentBranchUrl;
        this.myMergerFactory = mergerFactory;
    }

    @Override
    public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
        this.onBranchSelected(url, null, null);
    }

    public void onBranchSelected(String url, String selectedLocalBranchPath, String dialogTitle) {
        if (this.myCurrentBranch.toString().equals(url)) {
            Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.source.and.target.same.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
            return;
        }
        String name = SVNPathUtil.tail((String)this.myCurrentBranch.toString());
        Pair<WorkingCopyInfo, SVNURL> pair = IntegratedSelectedOptionsDialog.selectWorkingCopy(this.myVcs.getProject(), this.myCurrentBranch, url, true, selectedLocalBranchPath, dialogTitle);
        if (pair == null) {
            return;
        }
        WorkingCopyInfo info = (WorkingCopyInfo)pair.first;
        SVNURL realTargetUrl = (SVNURL)pair.second;
        SVNURL sourceUrl = this.correctSourceUrl(url, realTargetUrl.toString());
        if (sourceUrl == null) {
            return;
        }
        SvnIntegrateChangesTask task = new SvnIntegrateChangesTask(this.myVcs, info, this.myMergerFactory, sourceUrl, SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]), SvnConfiguration.getInstance((Project)this.myVcs.getProject()).MERGE_DRY_RUN, name);
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    private SVNURL correctSourceUrl(String targetUrl, String realTargetUrl) {
        try {
            if (realTargetUrl.length() > targetUrl.length()) {
                if (realTargetUrl.startsWith(targetUrl)) {
                    return this.myCurrentBranch.appendPath(realTargetUrl.substring(targetUrl.length()), true);
                }
            } else if (realTargetUrl.equals(targetUrl)) {
                return this.myCurrentBranch;
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return null;
    }
}

