/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.actions.ChangeSetMergerFactory;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SelectedChangeListsChecker;

public class SelectedChangeSetChecker
extends SelectedChangeListsChecker {
    private final List<Change> mySelectedChanges = new ArrayList<Change>();

    private void fillChanges(AnActionEvent event) {
        this.mySelectedChanges.clear();
        Change[] changes = (Change[])event.getData(VcsDataKeys.CHANGES);
        if (changes != null) {
            for (Change change : changes) {
                if (this.mySelectedChanges.contains(change)) continue;
                this.mySelectedChanges.add(change);
            }
        }
    }

    @Override
    public void execute(AnActionEvent event) {
        super.execute(event);
        this.fillChanges(event);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myChangeListsList.size() == 1 && !this.mySelectedChanges.isEmpty();
    }

    public MergerFactory createFactory() {
        return new ChangeSetMergerFactory((CommittedChangeList)this.myChangeListsList.get(0), this.mySelectedChanges);
    }

    public List<Change> getSelectedChanges() {
        return this.mySelectedChanges;
    }
}

