/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.dialogs.ChangeFormatDialog;
import org.jetbrains.idea.svn.dialogs.SvnFormatWorker;
import org.jetbrains.idea.svn.dialogs.WCInfo;

public class SvnMapDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private TableView<WCInfo> myTableView;
    private JButton myChangeFormatButton;
    private JButton myCorrectButton;
    private JLabel myWarningLabel;
    private JButton myRefresh;
    private ListTableModel<WCInfo> myTableModel;
    private final Project myProject;
    private final ActionListener myChangeFormatListener;
    private MessageBusConnection myMessageBusConnection;
    public static final Topic<Runnable> WC_CONVERTED = new Topic("WC_CONVERTED", Runnable.class);
    private static final ColumnInfo<WCInfo, String> WC_ROOT_PATH = new ColumnInfo<WCInfo, String>(SvnBundle.message("dialog.show.svn.map.table.header.column.wcpath.title", new Object[0])){

        public String valueOf(WCInfo info) {
            return info.getPath();
        }
    };
    private static final ColumnInfo<WCInfo, String> WC_URL = new ColumnInfo<WCInfo, String>(SvnBundle.message("dialog.show.svn.map.table.header.column.wcurl.title", new Object[0])){

        public String valueOf(WCInfo info) {
            return info.getUrl().toString();
        }
    };
    private static final ColumnInfo<WCInfo, String> WC_COPY_ROOT = new ColumnInfo<WCInfo, String>(SvnBundle.message("dialog.show.svn.map.table.header.column.wcroot.title", new Object[0])){

        public String valueOf(WCInfo info) {
            return info.isIsWcRoot() ? "yes" : "no";
        }
    };
    private static final ColumnInfo<WCInfo, String> WC_FORMAT = new ColumnInfo<WCInfo, String>(SvnBundle.message("dialog.show.svn.map.table.header.column.format.title", new Object[0])){

        public String valueOf(WCInfo info) {
            WorkingCopyFormat format = info.getFormat();
            return SvnUtil.formatRepresentation(format);
        }
    };
    private static final ColumnInfo<WCInfo, String> WC_TYPE = new ColumnInfo<WCInfo, String>("Type"){

        public String valueOf(WCInfo info) {
            NestedCopyType type = info.getType();
            return type == null ? "" : type.getName();
        }
    };

    public SvnMapDialog(final Project project) {
        super(project, true);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(SvnBundle.message("dialog.show.svn.map.title", objectArray));
        this.init();
        final SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        final List<WCInfo> infoList = vcs.getAllWcInfos();
        this.myTableModel.setItems(infoList);
        boolean promptForCorrection = vcs.getSvnFileUrlMapping().rootsDiffer();
        if (promptForCorrection) {
            this.myWarningLabel.setText(SvnBundle.message("action.working.copies.map.correct.warning.text", new Object[0]));
            this.myWarningLabel.setUI((LabelUI)new MultiLineLabelUI());
            this.myCorrectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SvnMapDialog.this.correctMappings(vcs, infoList);
                }
            });
        }
        this.myCorrectButton.setVisible(promptForCorrection);
        this.myWarningLabel.setVisible(promptForCorrection);
        this.myTableView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Collection selected = SvnMapDialog.this.myTableView.getSelection();
                SvnMapDialog.this.myChangeFormatButton.setEnabled(selected.size() == 1 && !ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning());
            }
        });
        this.myChangeFormatListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Collection selected = SvnMapDialog.this.myTableView.getSelection();
                if (selected.size() != 1) {
                    return;
                }
                WCInfo wcInfo = (WCInfo)selected.iterator().next();
                File path = new File(wcInfo.getPath());
                if (!wcInfo.isIsWcRoot()) {
                    path = SvnUtil.getWorkingCopyRoot(path);
                }
                ChangeFormatDialog dialog = new ChangeFormatDialog(project, path, false, !wcInfo.isIsWcRoot());
                dialog.setData(true, wcInfo.getFormat().getOption());
                dialog.show();
                if (!dialog.isOK()) {
                    return;
                }
                String newMode = dialog.getUpgradeMode();
                if (!wcInfo.getFormat().getOption().equals(newMode)) {
                    WorkingCopyFormat newFormat = WorkingCopyFormat.getInstance(newMode);
                    SvnFormatWorker task = new SvnFormatWorker(project, newFormat, wcInfo);
                    SvnMapDialog.this.doOKAction();
                    ProgressManager.getInstance().run((Task)task);
                }
            }
        };
        this.myChangeFormatButton.addActionListener(this.myChangeFormatListener);
        this.myChangeFormatButton.setEnabled(this.myTableView.getSelection().size() == 1 && !ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning());
        this.myRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnVcs vcs = SvnVcs.getInstance(SvnMapDialog.this.myProject);
                SvnMapDialog.this.subscribeToUpdates(vcs);
                vcs.invokeRefreshSvnRoots(false);
                SvnMapDialog.this.myRefresh.setEnabled(false);
            }
        });
    }

    protected String getHelpId() {
        return "reference.vcs.svn.working.copies.information";
    }

    private void subscribeToUpdates(final SvnVcs vcs) {
        if (this.myMessageBusConnection == null) {
            this.myMessageBusConnection = this.myProject.getMessageBus().connect(this.getDisposable());
            final ModalityState state = ModalityState.current();
            this.myMessageBusConnection.subscribe(SvnVcs.ROOTS_RELOADED, (Object)new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List<WCInfo> infoList = vcs.getAllWcInfos();
                            SvnMapDialog.this.myTableModel.setItems(infoList);
                            SvnMapDialog.this.myRefresh.setEnabled(true);
                            SvnMapDialog.this.myTableView.repaint();
                        }
                    }, state);
                }
            });
        }
    }

    private void correctMappings(SvnVcs vcs, List<WCInfo> infos) {
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)vcs.getProject());
        List mappings = manager.getDirectoryMappings();
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>();
        String svnVcsName = vcs.getName();
        for (VcsDirectoryMapping mapping : mappings) {
            if (svnVcsName.equals(mapping.getVcs())) continue;
            newMappings.add(mapping);
        }
        for (WCInfo info : infos) {
            newMappings.add(new VcsDirectoryMapping(FileUtil.toSystemIndependentName((String)info.getPath()), svnVcsName));
        }
        manager.setDirectoryMappings(newMappings);
        this.myCorrectButton.setVisible(false);
        this.myWarningLabel.setVisible(false);
    }

    public JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myTableModel = new ListTableModel(new ColumnInfo[]{WC_ROOT_PATH, WC_URL, WC_COPY_ROOT, WC_FORMAT, WC_TYPE}, Collections.emptyList(), 0);
        this.myTableView = new TableView(this.myTableModel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JButton jButton3;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 9, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 8, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myChangeFormatButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.show.svn.map.change.format.button.text"));
        jPanel2.add((Component)jButton3, new GridConstraints(1, 8, 1, 1, 4, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 9, 0, 3, 7, 7, null, null, null));
        TableView<WCInfo> tableView = this.myTableView;
        jScrollPane.setViewportView((Component)tableView);
        this.myWarningLabel = jLabel = new JLabel();
        jLabel.setText("");
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 9, 9, 0, 7, 0, null, null, null));
        this.myCorrectButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.working.copies.map.correct.roots.button.text"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRefresh = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.map.working.copies.button.refresh.text"));
        jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.show.svn.map.label.table.header"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

