/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;

public class ShareDialog
extends RepositoryBrowserDialog {
    private String mySelectedURL;

    public ShareDialog(Project project) {
        super(project);
    }

    public void init() {
        super.init();
        this.setTitle("Select Parent Location");
        this.setOKButtonText("Share");
        this.getRepositoryBrowser().addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ShareDialog.this.getOKAction() != null) {
                    ShareDialog.this.getOKAction().setEnabled(ShareDialog.this.getRepositoryBrowser().getSelectedURL() != null);
                }
            }
        });
        this.getOKAction().setEnabled(this.getRepositoryBrowser().getSelectedURL() != null);
        ((RepositoryTreeModel)this.getRepositoryBrowser().getRepositoryTree().getModel()).setShowFiles(false);
    }

    protected void doOKAction() {
        this.mySelectedURL = this.getRepositoryBrowser().getSelectedURL();
        super.doOKAction();
    }

    @Override
    public String getSelectedURL() {
        return this.mySelectedURL;
    }

    @Override
    protected JPopupMenu createPopup(boolean toolWindow) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup newGroup = new DefaultActionGroup("_New", true);
        newGroup.add((AnAction)new RepositoryBrowserDialog.AddLocationAction());
        newGroup.add((AnAction)new RepositoryBrowserDialog.MkDirAction());
        group.add((AnAction)newGroup);
        group.addSeparator();
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction());
        group.add((AnAction)new RepositoryBrowserDialog.DiscardLocationAction());
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
        return menu.getComponent();
    }
}

