/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.RunBackgroundable;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.util.Consumer;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.dialogs.BranchMerger;
import org.jetbrains.idea.svn.dialogs.IntersectingLocalChangesPanel;
import org.jetbrains.idea.svn.dialogs.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.dialogs.ToBeMergedDialog;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.TreeStructureNode;
import org.jetbrains.idea.svn.integrate.GroupMerger;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class QuickMerge {
    private final Project myProject;
    private final String myBranchName;
    private final VirtualFile myRoot;
    private WCInfo myWcInfo;
    private String mySourceUrl;
    private SvnVcs myVcs;
    private final String myTitle;
    private final Continuation myContinuation;

    public QuickMerge(Project project, String sourceUrl, WCInfo wcInfo, String branchName, VirtualFile root) {
        this.myProject = project;
        this.myBranchName = branchName;
        this.myRoot = root;
        this.myVcs = SvnVcs.getInstance(project);
        this.mySourceUrl = sourceUrl;
        this.myWcInfo = wcInfo;
        this.myTitle = "Merge from " + this.myBranchName;
        this.myContinuation = new Continuation(this.myProject, true);
    }

    private boolean prompt(String question) {
        return Messages.showOkCancelDialog((Project)this.myProject, (String)question, (String)this.myTitle, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public void execute() {
        LinkedList<TaskDescriptor> tasks = new LinkedList<TaskDescriptor>();
        tasks.add(new MyInitChecks());
        tasks.add(new SourceUrlCorrection());
        tasks.add(new CheckRepositorySupportsMergeinfo());
        this.myContinuation.run(tasks);
    }

    private void insertMergeAll(ContinuationContext context) {
        LinkedList<TaskDescriptor> queue = new LinkedList<TaskDescriptor>();
        this.insertMergeAll(queue);
        context.next(queue);
    }

    private boolean checkForSwitchedRoots() {
        List<WCInfo> infoList = this.myVcs.getAllWcInfos();
        boolean switchedFound = false;
        for (WCInfo wcInfo : infoList) {
            try {
                if (!FileUtil.isAncestor((File)new File(this.myWcInfo.getPath()), (File)new File(wcInfo.getPath()), (boolean)true) || !NestedCopyType.switched.equals((Object)wcInfo.getType())) continue;
                switchedFound = true;
                break;
            }
            catch (IOException e) {
            }
        }
        if (switchedFound) {
            return this.prompt("There are some switched paths in the working copy. Do you want to continue?");
        }
        return true;
    }

    private void finishWithError(ContinuationContext context, final String message, final List<VcsException> exceptions) {
        context.cancelEverything();
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                AbstractVcsHelper.getInstance((Project)QuickMerge.this.myProject).showErrors(exceptions, message);
            }
        }});
    }

    private void finishWithError(ContinuationContext context, final String message, final boolean isError) {
        context.cancelEverything();
        context.next(new TaskDescriptor[]{new TaskDescriptor(message, Where.AWT){

            public void run(ContinuationContext context) {
                ChangesViewBalloonProblemNotifier.showMe((Project)QuickMerge.this.myProject, (String)message, (MessageType)(isError ? MessageType.ERROR : MessageType.WARNING));
            }
        }});
    }

    private void insertMergeAll(List<TaskDescriptor> queue) {
        queue.add(new LocalChangesPrompt(true, null, null));
        MergeAllWithBranchCopyPoint mergeAllExecutor = new MergeAllWithBranchCopyPoint();
        queue.add(this.myVcs.getSvnBranchPointsCalculator().getFirstCopyPointTask(this.myWcInfo.getRepositoryRoot(), this.mySourceUrl, this.myWcInfo.getRootUrl(), mergeAllExecutor));
        queue.add(mergeAllExecutor);
    }

    private Intersection getMergeAllIntersection(List<LocalChangeList> localChangeLists) {
        Intersection intersection = new Intersection();
        for (LocalChangeList localChangeList : localChangeLists) {
            Collection localChanges = localChangeList.getChanges();
            for (Change localChange : localChanges) {
                intersection.add(localChangeList.getName(), localChangeList.getComment(), localChange);
            }
        }
        return intersection;
    }

    private static class Intersection {
        private final Map<String, String> myLists = new HashMap<String, String>();
        private final MultiMap<String, Change> myChangesSubset = new MultiMap();

        private Intersection() {
        }

        public void add(@NotNull String listName, @Nullable String comment, Change change) {
            if (listName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/QuickMerge$Intersection.add must not be null");
            }
            this.myChangesSubset.putValue((Object)listName, (Object)change);
            String commentToPut = comment == null ? listName : comment;
            this.myLists.put(listName, commentToPut);
        }

        public String getComment(String listName) {
            return this.myLists.get(listName);
        }

        public MultiMap<String, Change> getChangesSubset() {
            return this.myChangesSubset;
        }
    }

    private class ShelveLocalChanges
    extends TaskDescriptor {
        private final Intersection myIntersection;

        private ShelveLocalChanges(Intersection intersection) {
            super("Shelving local changes before merge", Where.POOLED);
            this.myIntersection = intersection;
        }

        public void run(final ContinuationContext context) {
            MultiMap<String, Change> map = this.myIntersection.getChangesSubset();
            RefreshSessionImpl session = new RefreshSessionImpl(true, false, new Runnable(){

                @Override
                public void run() {
                    context.ping();
                }
            });
            for (String name : map.keySet()) {
                try {
                    Collection changes = map.get((Object)name);
                    FileDocumentManager.getInstance().saveAllDocuments();
                    ShelveChangesManager.getInstance((Project)QuickMerge.this.myProject).shelveChanges(changes, this.myIntersection.getComment(name) + " (auto shelve before merge)");
                    session.addAllFiles(ChangesUtil.getFilesFromChanges((Collection)changes));
                }
                catch (IOException e) {
                    QuickMerge.this.finishWithError(context, e.getMessage(), true);
                }
                catch (VcsException e) {
                    QuickMerge.this.finishWithError(context, e.getMessage(), true);
                }
            }
            context.suspend();
            session.launch();
        }
    }

    private static enum LocalChangesAction {
        cancel,
        continueMerge,
        shelve,
        inspect;

    }

    private class LocalChangesPrompt
    extends TaskDescriptor {
        private final boolean myMergeAll;
        @Nullable
        private final List<CommittedChangeList> myLists;
        private final SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> myCopyPoint;

        private LocalChangesPrompt(@Nullable boolean mergeAll, @Nullable List<CommittedChangeList> lists, SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> copyPoint) {
            super("local changes intersection check", Where.AWT);
            this.myMergeAll = mergeAll;
            this.myLists = lists;
            this.myCopyPoint = copyPoint;
        }

        @Nullable
        private File getLocalPath(String relativeToRepoPath) {
            String pathToCheck = SVNPathUtil.append((String)QuickMerge.this.myWcInfo.getRepositoryRoot(), (String)relativeToRepoPath);
            SvnBranchPointsCalculator.BranchCopyData wrapped = this.myCopyPoint.getWrapped();
            String relativeInSource = SVNPathUtil.getRelativePath((String)(this.myCopyPoint.isInvertedSense() ? wrapped.getSource() : wrapped.getTarget()), (String)pathToCheck);
            if (StringUtil.isEmptyOrSpaces((String)relativeInSource)) {
                return null;
            }
            File local = new File(QuickMerge.this.myWcInfo.getPath(), relativeInSource);
            return local;
        }

        public void run(ContinuationContext context) {
            LocalChangesAction action;
            int result;
            LocalChangesAction[] possibleResults;
            String message;
            Intersection intersection;
            ChangeListManager listManager = ChangeListManager.getInstance((Project)QuickMerge.this.myProject);
            List localChangeLists = listManager.getChangeListsCopy();
            if (this.myMergeAll) {
                intersection = QuickMerge.this.getMergeAllIntersection(localChangeLists);
                message = "There are local changes that can potentially intersect with merge changes.\nDo you want to continue?";
            } else {
                intersection = this.checkIntersection(this.myLists, localChangeLists);
                message = "There are local changes that will intersect with merge changes.\nDo you want to continue?";
            }
            if (intersection == null || intersection.getChangesSubset().isEmpty()) {
                return;
            }
            if (!this.myMergeAll) {
                possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.inspect, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
                result = Messages.showDialog((String)message, (String)QuickMerge.this.myTitle, (String[])new String[]{"Shelve local changes", "Inspect changes", "Continue merge", "Cancel"}, (int)0, (Icon)Messages.getQuestionIcon());
                action = possibleResults[result];
            } else {
                possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
                result = Messages.showDialog((String)message, (String)QuickMerge.this.myTitle, (String[])new String[]{"Shelve local changes", "Continue merge", "Cancel"}, (int)0, (Icon)Messages.getQuestionIcon());
                action = possibleResults[result];
            }
            switch (action) {
                case shelve: {
                    context.next(new TaskDescriptor[]{new ShelveLocalChanges(intersection)});
                    return;
                }
                case cancel: {
                    context.cancelEverything();
                    return;
                }
                case continueMerge: {
                    return;
                }
                case inspect: {
                    Collection changes = intersection.getChangesSubset().values();
                    List paths = ChangesUtil.getPaths((Collection)changes);
                    Collections.sort(paths, FilePathByPathComparator.getInstance());
                    IntersectingLocalChangesPanel.showInVersionControlToolWindow(QuickMerge.this.myProject, QuickMerge.this.myTitle + ", local changes intersection", paths, "The following file(s) have local changes that will intersect with merge changes:");
                    context.cancelEverything();
                    return;
                }
            }
        }

        @Nullable
        private Intersection checkIntersection(@Nullable List<CommittedChangeList> lists, List<LocalChangeList> localChangeLists) {
            if (lists == null || lists.isEmpty()) {
                return null;
            }
            HashSet<FilePathImpl> mergePaths = new HashSet<FilePathImpl>();
            for (CommittedChangeList list : lists) {
                SvnChangeList svnList = (SvnChangeList)list;
                ArrayList<String> paths = new ArrayList<String>(svnList.getAddedPaths());
                paths.addAll(svnList.getChangedPaths());
                paths.addAll(svnList.getDeletedPaths());
                for (String path : paths) {
                    File localPath = this.getLocalPath(path);
                    if (localPath == null) continue;
                    mergePaths.add(new FilePathImpl(localPath, false));
                }
            }
            Intersection intersection = new Intersection();
            for (LocalChangeList localChangeList : localChangeLists) {
                Collection localChanges = localChangeList.getChanges();
                for (Change localChange : localChanges) {
                    FilePath after;
                    FilePath before = localChange.getBeforeRevision() == null ? null : localChange.getBeforeRevision().getFile();
                    FilePath filePath = after = localChange.getAfterRevision() == null ? null : localChange.getAfterRevision().getFile();
                    if ((before == null || !mergePaths.contains(before)) && (after == null || !mergePaths.contains(after))) continue;
                    intersection.add(localChangeList.getName(), localChangeList.getComment(), localChange);
                }
            }
            return intersection;
        }
    }

    private class MergeCalculator
    extends TaskDescriptor
    implements Consumer<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>> {
        private static final String ourOneShotStrategy = "svn.quickmerge.oneShotStrategy";
        private final WCInfo myWcInfo;
        private final String mySourceUrl;
        private final String myBranchName;
        private SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> myCopyData;
        private boolean myIsReintegrate;
        private final List<CommittedChangeList> myNotMerged;
        private String myMergeTitle;
        private final MergeChecker myMergeChecker;

        public void consume(SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> branchCopyDataWrapperInvertor) {
            this.myCopyData = branchCopyDataWrapperInvertor;
        }

        private MergeCalculator(WCInfo wcInfo, String sourceUrl, String branchName) throws SVNException {
            super("Calculating not merged revisions", Where.POOLED);
            this.myWcInfo = wcInfo;
            this.mySourceUrl = sourceUrl;
            this.myBranchName = branchName;
            this.myNotMerged = new LinkedList<CommittedChangeList>();
            this.myMergeTitle = "Merge from " + branchName;
            this.myMergeChecker = new OneShotMergeInfoHelper(QuickMerge.this.myProject, this.myWcInfo, this.mySourceUrl);
            ((OneShotMergeInfoHelper)this.myMergeChecker).prepare();
        }

        public void run(ContinuationContext context) {
            if (this.myCopyData == null) {
                QuickMerge.this.finishWithError(context, "Merge start wasn't found", true);
                return;
            }
            final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            this.myIsReintegrate = this.myCopyData.isInvertedSense();
            if (!this.myWcInfo.getFormat().supportsMergeInfo()) {
                return;
            }
            SvnBranchPointsCalculator.BranchCopyData data = this.myCopyData.getTrue();
            final long sourceLatest = data.getTargetRevision();
            SvnCommittedChangesProvider committedChangesProvider = (SvnCommittedChangesProvider)QuickMerge.this.myVcs.getCommittedChangesProvider();
            ChangeBrowserSettings settings = new ChangeBrowserSettings();
            settings.CHANGE_AFTER = Long.toString(sourceLatest);
            settings.USE_CHANGE_AFTER_FILTER = true;
            String local = SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.myWcInfo.getRootUrl());
            String relativeLocal = local.startsWith("/") ? local : "/" + local;
            final LinkedList list = new LinkedList();
            try {
                committedChangesProvider.getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.mySourceUrl), 0, new PairConsumer<SvnChangeList, TreeStructureNode<SVNLogEntry>>(){

                    public void consume(SvnChangeList svnList, TreeStructureNode<SVNLogEntry> tree) {
                        indicator.checkCanceled();
                        if (sourceLatest >= svnList.getNumber()) {
                            return;
                        }
                        list.add(new Pair((Object)svnList, tree));
                    }
                });
            }
            catch (VcsException e) {
                QuickMerge.this.finishWithError(context, "Checking revisions for merge fault", Collections.singletonList(e));
            }
            indicator.setText("Checking merge information...");
            for (Pair pair : list) {
                SvnChangeList svnList = (SvnChangeList)pair.getFirst();
                SvnMergeInfoCache.MergeCheckResult checkResult = this.myMergeChecker.checkList(svnList);
                indicator.setText2("Processing revision " + svnList.getNumber());
                if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)checkResult)) continue;
                List children = ((TreeStructureNode)pair.getSecond()).getChildren();
                boolean localChange = false;
                for (TreeStructureNode<SVNLogEntry> treeStructureNode : children) {
                    if (!this.isLocalRevisionMergeIteration(treeStructureNode, relativeLocal, indicator)) continue;
                    localChange = true;
                    break;
                }
                if (localChange) continue;
                this.myNotMerged.add(svnList);
            }
            if (this.myNotMerged.isEmpty()) {
                QuickMerge.this.finishWithError(context, "Everything is up-to-date", false);
                return;
            }
            context.next(new TaskDescriptor[]{new ShowRevisionSelector(this.myCopyData)});
        }

        private boolean isLocalRevisionMergeIteration(TreeStructureNode<SVNLogEntry> tree, String localURL, ProgressIndicator indicator) {
            LinkedList queue = new LinkedList();
            queue.addLast(tree);
            while (!queue.isEmpty()) {
                Object o;
                SVNLogEntryPath path;
                TreeStructureNode element = (TreeStructureNode)queue.removeFirst();
                indicator.checkCanceled();
                Map map = ((SVNLogEntry)element.getMe()).getChangedPaths();
                Iterator i$ = map.values().iterator();
                if (i$.hasNext() && SVNPathUtil.isAncestor((String)localURL, (String)(path = (SVNLogEntryPath)(o = i$.next())).getPath())) {
                    return true;
                }
                queue.addAll(element.getChildren());
            }
            return false;
        }

        private class ShowRevisionSelector
        extends TaskDescriptor {
            private final SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> myCopyPoint;

            private ShowRevisionSelector(SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> copyPoint) {
                super("show revisions to merge", Where.AWT);
                this.myCopyPoint = copyPoint;
            }

            public void run(ContinuationContext context) {
                ToBeMergedDialog dialog = new ToBeMergedDialog(QuickMerge.this.myProject, MergeCalculator.this.myNotMerged, MergeCalculator.this.myMergeTitle, MergeCalculator.this.myMergeChecker);
                dialog.show();
                if (dialog.getExitCode() == 1) {
                    context.cancelEverything();
                    return;
                }
                if (dialog.getExitCode() == 222) {
                    QuickMerge.this.insertMergeAll(context);
                } else {
                    final List<CommittedChangeList> lists = dialog.getSelected();
                    if (lists.isEmpty()) {
                        return;
                    }
                    ChangeListsMergerFactory factory = new ChangeListsMergerFactory(lists){

                        @Override
                        public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
                            return new GroupMerger(vcs, lists, target, handler, currentBranchUrl, branchName, false, false, false);
                        }
                    };
                    context.next(new TaskDescriptor[]{new LocalChangesPrompt(false, lists, this.myCopyPoint), new MergeTask(factory, MergeCalculator.this.myMergeTitle)});
                }
            }
        }
    }

    private class MergeTask
    extends TaskDescriptor {
        private final MergerFactory myFactory;

        private MergeTask(MergerFactory factory, String mergeTitle) {
            super(mergeTitle, Where.AWT);
            this.myFactory = factory;
        }

        public void run(ContinuationContext context) {
            SVNURL sourceUrlUrl;
            try {
                sourceUrlUrl = SVNURL.parseURIEncoded((String)QuickMerge.this.mySourceUrl);
            }
            catch (SVNException e) {
                QuickMerge.this.finishWithError(context, "Cannot merge: " + e.getMessage(), true);
                return;
            }
            context.next(new TaskDescriptor[]{new TaskDescriptor(this.getName(), Where.POOLED){

                public void run(ContinuationContext context) {
                    SvnIntegrateChangesTask task = new SvnIntegrateChangesTask(SvnVcs.getInstance(QuickMerge.this.myProject), new WorkingCopyInfo(QuickMerge.this.myWcInfo.getPath(), true), MergeTask.this.myFactory, sourceUrlUrl, this.getName(), false, QuickMerge.this.myBranchName);
                    RunBackgroundable.run((Task)task);
                }
            }});
            this.createChangelist(context);
        }

        private void createChangelist(final ContinuationContext context) {
            ChangeListManager listManager = ChangeListManager.getInstance((Project)QuickMerge.this.myProject);
            String name = QuickMerge.this.myTitle;
            int i = 1;
            boolean updateDefaultList = false;
            while (true) {
                LocalChangeList changeList;
                if ((changeList = listManager.findChangeList(name)) == null) {
                    LocalChangeList newList = listManager.addChangeList(name, null);
                    listManager.setDefaultChangeList(newList);
                    updateDefaultList = true;
                    break;
                }
                if (changeList.getChanges().isEmpty()) {
                    if (changeList.isDefault()) break;
                    listManager.setDefaultChangeList(changeList);
                    updateDefaultList = true;
                    break;
                }
                name = QuickMerge.this.myTitle + " (" + i + ")";
                ++i;
            }
            if (updateDefaultList) {
                context.suspend();
                listManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        context.ping();
                    }
                }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE_NOT_AWT, "", ModalityState.NON_MODAL);
            }
        }
    }

    private class MergeAllWithBranchCopyPoint
    extends TaskDescriptor
    implements Consumer<SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData>> {
        private SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> myData;

        private MergeAllWithBranchCopyPoint() {
            super("merge all", Where.AWT);
        }

        public void consume(SvnBranchPointsCalculator.WrapperInvertor<SvnBranchPointsCalculator.BranchCopyData> data) {
            this.myData = data;
        }

        public void run(ContinuationContext context) {
            if (this.myData == null) {
                QuickMerge.this.finishWithError(context, "Merge start wasn't found", true);
                return;
            }
            boolean reintegrate = this.myData.isInvertedSense();
            if (reintegrate && !QuickMerge.this.prompt("You are going to reintegrate changes.\nThis will make " + QuickMerge.this.mySourceUrl + " no longer usable for further work." + "\nAre you sure?")) {
                context.cancelEverything();
                return;
            }
            MergerFactory mergerFactory = this.createBranchMergerFactory(reintegrate);
            String title = "Merging all from " + QuickMerge.this.myBranchName + (reintegrate ? " (reintegrate)" : "");
            context.next(new TaskDescriptor[]{new MergeTask(mergerFactory, title)});
        }

        private MergerFactory createBranchMergerFactory(final boolean reintegrate) {
            return new MergerFactory(){

                @Override
                public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
                    return new BranchMerger(vcs, currentBranchUrl, QuickMerge.this.myWcInfo.getUrl(), QuickMerge.this.myWcInfo.getPath(), handler, reintegrate, QuickMerge.this.myBranchName, reintegrate ? ((SvnBranchPointsCalculator.BranchCopyData)MergeAllWithBranchCopyPoint.this.myData.getWrapped()).getTargetRevision() : ((SvnBranchPointsCalculator.BranchCopyData)MergeAllWithBranchCopyPoint.this.myData.getWrapped()).getSourceRevision());
                }

                @Override
                @Nullable
                public List<CommittedChangeList> getListsToMerge() {
                    return null;
                }

                @Override
                public boolean isMergeAll() {
                    return true;
                }
            };
        }
    }

    private class MergeAllOrSelectedChooser
    extends TaskDescriptor {
        private MergeAllOrSelectedChooser() {
            super("merge source selector", Where.AWT);
        }

        public void run(ContinuationContext context) {
            MergeCalculator calculator;
            int result = Messages.showDialog((Project)QuickMerge.this.myProject, (String)"Merge all?", (String)QuickMerge.this.myTitle, (String[])new String[]{"Merge &all", "&Select revisions to merge", "Cancel"}, (int)0, (Icon)Messages.getQuestionIcon());
            if (result == 2) {
                return;
            }
            if (result == 0) {
                QuickMerge.this.insertMergeAll(context);
                return;
            }
            try {
                calculator = new MergeCalculator(QuickMerge.this.myWcInfo, QuickMerge.this.mySourceUrl, QuickMerge.this.myBranchName);
            }
            catch (SVNException e) {
                QuickMerge.this.finishWithError(context, e.getMessage(), true);
                return;
            }
            context.next(new TaskDescriptor[]{QuickMerge.this.myVcs.getSvnBranchPointsCalculator().getFirstCopyPointTask(QuickMerge.this.myWcInfo.getRepositoryRoot(), QuickMerge.this.myWcInfo.getRootUrl(), QuickMerge.this.mySourceUrl, calculator), calculator});
        }
    }

    private class CheckRepositorySupportsMergeinfo
    extends TaskDescriptor {
        private CheckRepositorySupportsMergeinfo() {
            super("Checking repository capabilities", Where.POOLED);
        }

        public void run(ContinuationContext context) {
            try {
                boolean supportsMergeinfo;
                LinkedList<MergeAllOrSelectedChooser> tasks = new LinkedList<MergeAllOrSelectedChooser>();
                boolean bl = supportsMergeinfo = QuickMerge.this.myWcInfo.getFormat().supportsMergeInfo() && SvnUtil.doesRepositorySupportMergeinfo(QuickMerge.this.myVcs, SVNURL.parseURIEncoded((String)QuickMerge.this.mySourceUrl));
                if (!supportsMergeinfo) {
                    QuickMerge.this.insertMergeAll(tasks);
                } else {
                    tasks.add(new MergeAllOrSelectedChooser());
                }
                context.next(tasks);
            }
            catch (SVNException e) {
                QuickMerge.this.finishWithError(context, e.getMessage(), true);
            }
        }
    }

    private class MyInitChecks
    extends TaskDescriptor {
        private MyInitChecks() {
            super("initial checks", Where.AWT);
        }

        public void run(ContinuationContext continuationContext) {
            if (SVNPathUtil.isAncestor((String)QuickMerge.this.mySourceUrl, (String)QuickMerge.this.myWcInfo.getRootUrl()) || SVNPathUtil.isAncestor((String)QuickMerge.this.myWcInfo.getRootUrl(), (String)QuickMerge.this.mySourceUrl)) {
                QuickMerge.this.finishWithError(continuationContext, "Cannot merge from self", true);
                return;
            }
            if (!QuickMerge.this.checkForSwitchedRoots()) {
                continuationContext.cancelEverything();
            }
        }
    }

    private class SourceUrlCorrection
    extends TaskDescriptor {
        private SourceUrlCorrection() {
            super("Checking branch", Where.POOLED);
        }

        public void run(ContinuationContext continuationContext) {
            String branchString;
            SVNURL branch = SvnBranchConfigurationManager.getInstance(QuickMerge.this.myProject).getSvnBranchConfigManager().getWorkingBranchWithReload(QuickMerge.this.myWcInfo.getUrl(), QuickMerge.this.myRoot);
            if (branch != null && !QuickMerge.this.myWcInfo.getUrl().equals((Object)branch) && SVNPathUtil.isAncestor((String)(branchString = branch.toString()), (String)QuickMerge.this.myWcInfo.getRootUrl())) {
                String subPath = SVNPathUtil.getRelativePath((String)branchString, (String)QuickMerge.this.myWcInfo.getRootUrl());
                QuickMerge.this.mySourceUrl = SVNPathUtil.append((String)QuickMerge.this.mySourceUrl, (String)subPath);
            }
        }
    }
}

