/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnMergeProvider
implements MergeProvider {
    private final Project myProject;

    public SvnMergeProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public MergeData loadRevisions(final VirtualFile file) throws VcsException {
        final MergeData data = new MergeData();
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                SVNWCClient client;
                SvnVcs vcs = SvnVcs.getInstance(SvnMergeProvider.this.myProject);
                File oldFile = null;
                File newFile = null;
                File workingFile = null;
                try {
                    client = vcs.createWCClient();
                    SVNInfo info = client.doInfo(new File(file.getPath()), SVNRevision.WORKING);
                    if (info != null) {
                        oldFile = info.getConflictOldFile();
                        newFile = info.getConflictNewFile();
                        workingFile = info.getConflictWrkFile();
                        data.LAST_REVISION_NUMBER = new SvnRevisionNumber(info.getRevision());
                    }
                }
                catch (SVNException e) {
                    throw new VcsException((Throwable)e);
                }
                if (oldFile == null || newFile == null || workingFile == null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        client.doGetFileContents(new File(file.getPath()), SVNRevision.UNDEFINED, SVNRevision.BASE, true, (OutputStream)bos);
                    }
                    catch (SVNException e) {
                        // empty catch block
                    }
                    data.ORIGINAL = bos.toByteArray();
                    data.LAST = bos.toByteArray();
                    data.CURRENT = SvnMergeProvider.readFile(new File(file.getPath()));
                } else {
                    data.ORIGINAL = SvnMergeProvider.readFile(oldFile);
                    data.LAST = SvnMergeProvider.readFile(newFile);
                    data.CURRENT = SvnMergeProvider.readFile(workingFile);
                }
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)VcsBundle.message((String)"multiple.file.merge.loading.progress.title", (Object[])new Object[0]), (boolean)false, (Project)this.myProject);
        MergeData mergeData = data;
        if (mergeData == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/actions/SvnMergeProvider.loadRevisions must not return null");
        }
        return mergeData;
    }

    private static byte[] readFile(File workingFile) throws VcsException {
        try {
            return FileUtil.loadFileBytes((File)workingFile);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void conflictResolvedForFile(VirtualFile file) {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        try {
            SVNWCClient client = vcs.createWCClient();
            client.doResolve(new File(file.getPath()), SVNDepth.EMPTY, true, false, SVNConflictChoice.MERGED);
        }
        catch (SVNException e) {
            // empty catch block
        }
        VirtualFile parent = file.getParent();
        if (parent != null) {
            parent.refresh(true, false);
        }
    }

    public boolean isBinary(VirtualFile file) {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        try {
            SVNWCClient client = vcs.createWCClient();
            File ioFile = new File(file.getPath());
            SVNPropertyData svnPropertyData = client.doGetProperty(ioFile, "svn:mime-type", SVNRevision.UNDEFINED, SVNRevision.WORKING);
            if (svnPropertyData != null && SVNProperty.isBinaryMimeType((String)SVNPropertyValue.getPropertyAsString((SVNPropertyValue)svnPropertyData.getValue()))) {
                return true;
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return false;
    }
}

