/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnStatusUtil {
    private static final List<SVNStatusType> ourUnderAndLive = Arrays.asList(SVNStatusType.STATUS_ADDED, SVNStatusType.STATUS_CONFLICTED, SVNStatusType.STATUS_INCOMPLETE, SVNStatusType.MERGED, SVNStatusType.STATUS_MODIFIED, SVNStatusType.STATUS_EXTERNAL, SVNStatusType.STATUS_NORMAL, SVNStatusType.STATUS_REPLACED);
    private static final List<SVNStatusType> ourCanBeAdded = Arrays.asList(SVNStatusType.STATUS_IGNORED, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_UNVERSIONED, SVNStatusType.UNKNOWN);

    private SvnStatusUtil() {
    }

    public static boolean notUnderControl(SVNStatus status) {
        return status == null || ourCanBeAdded.contains(status.getContentsStatus());
    }

    public static boolean isUnderControl(Project project, VirtualFile file) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        return !SvnStatusUtil.isIgnoredInAnySense(clManager, file) && !clManager.isUnversioned(file);
    }

    public static boolean isAdded(Project project, VirtualFile file) {
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file);
        return FileStatus.ADDED.equals(status);
    }

    public static boolean isExplicitlyLocked(Project project, VirtualFile file) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        return ((ChangeListManagerImpl)clManager).isLogicallyLocked(file);
    }

    public static boolean isIgnoredInAnySense(ChangeListManager clManager, VirtualFile file) {
        return clManager.isIgnoredFile(file) || FileStatus.IGNORED.equals(clManager.getStatus(file));
    }

    public static boolean isValidUnderControlParent(SVNStatus status) {
        if (status == null) {
            return false;
        }
        if (status.isSwitched() || status.isCopied()) {
            return true;
        }
        return ourUnderAndLive.contains(status.getContentsStatus());
    }

    public static boolean fileCanBeAdded(Project project, VirtualFile file) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        return SvnStatusUtil.isIgnoredInAnySense(clManager, file) || clManager.isUnversioned(file);
    }
}

