/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.lifecycle.ControlledAlarmFactory;
import com.intellij.lifecycle.SlowlyClosingAlarm;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import org.jetbrains.idea.svn.CopiesRefresh;
import org.jetbrains.idea.svn.RequestsMerger;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;

public class SvnCopiesRefreshManager {
    private final CopiesRefresh myCopiesRefresh = new MyVeryRefresh();

    public SvnCopiesRefreshManager(Project project, SvnFileUrlMappingImpl mapping) {
        final SlowlyClosingAlarm alarm = ControlledAlarmFactory.createOnOwnThread((Project)project, (String)"Subversion working copies refresher");
        MyRefresher refresher = new MyRefresher(project, mapping, (AtomicSectionsAware)alarm);
        RequestsMerger requestsMerger = new RequestsMerger(refresher, new Consumer<Runnable>(){

            public void consume(Runnable runnable) {
                alarm.addRequest(runnable);
            }
        });
        ((MyVeryRefresh)this.myCopiesRefresh).setRequestMerger(requestsMerger);
    }

    public CopiesRefresh getCopiesRefresh() {
        return this.myCopiesRefresh;
    }

    private static class MyRefresher
    implements Runnable {
        private final Project myProject;
        private final SvnFileUrlMappingImpl myMapping;
        private final AtomicSectionsAware myAtomicSectionsAware;

        private MyRefresher(Project project, SvnFileUrlMappingImpl mapping, AtomicSectionsAware atomicSectionsAware) {
            this.myProject = project;
            this.myMapping = mapping;
            this.myAtomicSectionsAware = atomicSectionsAware;
        }

        @Override
        public void run() {
            try {
                this.myMapping.realRefresh(this.myAtomicSectionsAware);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private class MyVeryRefresh
    implements CopiesRefresh {
        private static final long ourQueryInterval = 1000L;
        private RequestsMerger myRequestMerger;
        private final ProgressManager myPm = ProgressManager.getInstance();

        private MyVeryRefresh() {
        }

        public void setRequestMerger(RequestsMerger requestMerger) {
            this.myRequestMerger = requestMerger;
        }

        @Override
        public void ensureInit() {
            this.synchRequest(this.myPm.getProgressIndicator(), true);
        }

        @Override
        public void asynchRequest() {
            this.myRequestMerger.request();
        }

        @Override
        public void synchRequest() {
            this.synchRequest(this.myPm.getProgressIndicator(), false);
        }

        private void synchRequest(ProgressIndicator pi, boolean isOnlyInit) {
            final Semaphore semaphore = new Semaphore();
            Runnable waiter = new Runnable(){

                @Override
                public void run() {
                    semaphore.up();
                }
            };
            semaphore.down();
            if (isOnlyInit) {
                this.myRequestMerger.ensureInitialization(waiter);
            } else {
                this.myRequestMerger.waitRefresh(waiter);
            }
            while (!semaphore.waitFor(1000L)) {
                if (pi == null) continue;
                pi.checkCanceled();
            }
        }
    }
}

