/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChangeTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    @NotNull
    public String getName() {
        String string = SpellCheckerBundle.message("change.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/ChangeTo.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpellCheckerBundle.message("change.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/ChangeTo.getFamilyName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.FIRST;
        if (anchor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/ChangeTo.getPopupActionAnchor must not return null");
        }
        return anchor;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/quickfixes/ChangeTo.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/quickfixes/ChangeTo.applyFix must not be null");
        }
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)element);
        if (!(navigatable instanceof OpenFileDescriptor)) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor((OpenFileDescriptor)navigatable, true);
        if (editor == null) {
            return;
        }
        TextRange textRange = ((ProblemDescriptorImpl)descriptor).getTextRange();
        editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        String word = editor.getSelectionModel().getSelectedText();
        if (word == null || StringUtil.isEmpty((String)word)) {
            return;
        }
        ArrayList<LookupElementBuilder> lookupItems = new ArrayList<LookupElementBuilder>();
        for (String variant : this.getSuggestions()) {
            lookupItems.add(LookupElementBuilder.create((String)variant));
        }
        LookupElement[] items = new LookupElement[lookupItems.size()];
        items = lookupItems.toArray(items);
        LookupManager lookupManager = LookupManager.getInstance((Project)project);
        lookupManager.showLookup(editor, items);
    }
}

