/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

public class CheckArea {
    private String text;
    private TextRange textRange;
    private boolean ignored;

    public CheckArea(String text, TextRange range) {
        this.text = text;
        this.textRange = range;
    }

    public CheckArea(String text, TextRange textRange, boolean ignored) {
        this.text = text;
        this.textRange = textRange;
        this.ignored = ignored;
    }

    public TextRange getTextRange() {
        return this.textRange;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    @Nullable
    public String getWord() {
        if (this.text == null || this.textRange == null) {
            return null;
        }
        return this.text.substring(this.textRange.getStartOffset(), this.textRange.getEndOffset());
    }

    public String toString() {
        return "CheckArea{range = " + this.textRange + ", ignored=" + this.ignored + ", word=" + (this.getWord() != null ? this.getWord() : "") + '}';
    }
}

