/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.engine.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BaseSuggestionProvider
implements SuggestionProvider {
    private final SpellCheckerManager manager;

    public BaseSuggestionProvider(@NotNull SpellCheckerManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/BaseSuggestionProvider.<init> must not be null");
        }
        this.manager = manager;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/BaseSuggestionProvider.getSuggestions must not be null");
        }
        String[] words = NameUtil.nameToWords((String)text);
        int index = 0;
        List[] res = new List[words.length];
        int i = 0;
        for (String word : words) {
            List<String> variants;
            int start = text.indexOf(word, index);
            int end = start + word.length();
            if (!this.manager.hasProblem(word)) {
                variants = new ArrayList<String>();
                variants.add(word);
                res[i++] = variants;
            } else {
                variants = this.manager.getRawSuggestions(word);
                res[i++] = variants;
            }
            index = end;
        }
        int[] counter = new int[i];
        int size = 1;
        for (int j = 0; j < i; ++j) {
            size *= res[j].size();
        }
        String[] all = new String[size];
        for (int k = 0; k < size; ++k) {
            for (int j = 0; j < i; ++j) {
                if (all[k] == null) {
                    all[k] = "";
                }
                int n = k;
                all[n] = all[n] + res[j].get(counter[j]);
                int n2 = j;
                counter[n2] = counter[n2] + 1;
                if (counter[j] < res[j].size()) continue;
                counter[j] = 0;
            }
        }
        List<String> list = Arrays.asList(all);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/BaseSuggestionProvider.getSuggestions must not return null");
        }
        return list;
    }
}

