/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.ui;

import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;

public class RemoveAction
extends AbstractAction {
    private final IGTable table;

    public RemoveAction(IGTable table) {
        this.table = table;
        this.putValue("Name", InspectionGadgetsBundle.message("button.remove", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int minIndex = selectionModel.getMinSelectionIndex();
        int maxIndex = selectionModel.getMaxSelectionIndex();
        if (minIndex == -1 || maxIndex == -1) {
            return;
        }
        ListWrappingTableModel tableModel = this.table.getModel();
        for (int i = minIndex; i <= maxIndex; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            tableModel.removeRow(i);
        }
        int count = tableModel.getRowCount();
        if (count <= minIndex) {
            selectionModel.setSelectionInterval(count - 1, count - 1);
        } else if (minIndex <= 0) {
            if (count > 0) {
                selectionModel.setSelectionInterval(0, 0);
            }
        } else {
            selectionModel.setSelectionInterval(minIndex - 1, minIndex - 1);
        }
    }
}

