/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import java.lang.reflect.Field;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckBox
extends JCheckBox {
    public CheckBox(@NotNull String label, @NotNull InspectionProfileEntry owner, @NonNls String property) {
        if (label == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/ui/CheckBox.<init> must not be null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/ui/CheckBox.<init> must not be null");
        }
        super(label, CheckBox.getPropertyValue(owner, property));
        ButtonModel model = this.getModel();
        SingleCheckboxChangeListener listener = new SingleCheckboxChangeListener(owner, property, model);
        model.addChangeListener(listener);
    }

    private static boolean getPropertyValue(InspectionProfileEntry owner, String property) {
        try {
            Class<?> aClass = owner.getClass();
            Field field = aClass.getField(property);
            return field.getBoolean(owner);
        }
        catch (IllegalAccessException ignore) {
            return false;
        }
        catch (NoSuchFieldException ignore) {
            return false;
        }
    }

    private static class SingleCheckboxChangeListener
    implements ChangeListener {
        private final InspectionProfileEntry owner;
        private final String property;
        private final ButtonModel model;

        SingleCheckboxChangeListener(InspectionProfileEntry owner, String property, ButtonModel model) {
            this.owner = owner;
            this.property = property;
            this.model = model;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SingleCheckboxChangeListener.setPropertyValue(this.owner, this.property, this.model.isSelected());
        }

        private static void setPropertyValue(InspectionProfileEntry owner, String property, boolean selected) {
            try {
                Class<?> aClass = owner.getClass();
                Field field = aClass.getField(property);
                field.setBoolean(owner, selected);
            }
            catch (IllegalAccessException ignore) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }
}

