/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryInheritDocInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryInheritDocInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryInheritDocInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryInheritDocFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInheritDocVisitor();
    }

    private static class UnnecessaryInheritDocVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInheritDocVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            if (!(tag instanceof PsiInlineDocTag)) {
                return;
            }
            String name = tag.getName();
            if (!"inheritDoc".equals(name)) {
                return;
            }
            PsiDocComment docComment = tag.getContainingComment();
            if (docComment == null) {
                return;
            }
            PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)docComment, PsiDocToken.class);
            if (docTokens == null) {
                return;
            }
            for (PsiDocToken docToken : docTokens) {
                IElementType tokenType = docToken.getTokenType();
                if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces((String)docToken.getText())) continue;
                return;
            }
            this.registerError((PsiElement)tag, new Object[0]);
        }
    }

    private class UnnecessaryInheritDocFix
    extends InspectionGadgetsFix {
        private UnnecessaryInheritDocFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryInheritDocInspection$UnnecessaryInheritDocFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiDocTag)) {
                return;
            }
            PsiDocTag docTag = (PsiDocTag)element;
            PsiDocComment docComment = docTag.getContainingComment();
            docComment.delete();
        }
    }
}

