/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryFullyQualifiedNameInspection
extends BaseInspection {
    public boolean m_ignoreJavadoc = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreJavadoc");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean inSameFile = (Boolean)infos[0];
        if (inSameFile) {
            string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.problem.descriptor2", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.problem.descriptor1", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection.buildErrorString must not return null");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryFullyQualifiedNameFix((Boolean)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFullyQualifiedNameVisitor();
    }

    private class UnnecessaryFullyQualifiedNameVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFullyQualifiedNameVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            this.checkReference((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            this.checkReference(reference);
        }

        private void checkReference(PsiJavaCodeReferenceElement reference) {
            String fqName;
            PsiElement containingComment;
            if (!reference.isQualified()) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (parent instanceof PsiMethodCallExpression || parent instanceof PsiAssignmentExpression || parent instanceof PsiVariable) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiImportStatementBase.class, PsiPackageStatement.class, JavaCodeFragment.class});
            if (element != null) {
                return;
            }
            if (UnnecessaryFullyQualifiedNameInspection.this.m_ignoreJavadoc && (containingComment = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiDocComment.class)) != null) {
                return;
            }
            PsiFile containingFile = reference.getContainingFile();
            if (!(containingFile instanceof PsiJavaFile)) {
                return;
            }
            PsiElement psiElement = reference.resolve();
            if (!(psiElement instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)psiElement;
            Project project = aClass.getProject();
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)project);
            if (!styleSettings.INSERT_INNER_CLASS_IMPORTS) {
                aClass = ClassUtils.getOutermostContainingClass(aClass);
            }
            if ((fqName = aClass.getQualifiedName()) == null) {
                return;
            }
            String referenceText = reference.getText();
            String text = StringUtils.stripAngleBrackets(referenceText);
            if (!text.equals(fqName)) {
                return;
            }
            if (!ImportUtils.nameCanBeImported(fqName, (PsiElement)reference)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)containingFile;
            String packageName = javaFile.getPackageName();
            String elementPackageName = ClassUtil.extractPackageName((String)text);
            boolean inSameFile = elementPackageName.equals(packageName);
            this.registerError((PsiElement)reference, inSameFile);
        }
    }

    private static class UnnecessaryFullyQualifiedNameFix
    extends InspectionGadgetsFix {
        private final boolean inSameFile;

        public UnnecessaryFullyQualifiedNameFix(boolean inSameFile) {
            this.inSameFile = inSameFile;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getName() {
            String string;
            if (this.inSameFile) {
                string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.remove.quickfix", new Object[0]);
                if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection$UnnecessaryFullyQualifiedNameFix.getName must not return null");
                return string;
            }
            string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.replace.quickfix", new Object[0]);
            if (string != null) return string;
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection$UnnecessaryFullyQualifiedNameFix.getName must not return null");
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String packageName;
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)descriptor.getPsiElement();
            PsiJavaFile file = (PsiJavaFile)referenceElement.getContainingFile();
            if (file == null) {
                return;
            }
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return;
            }
            PsiClass aClass = (PsiClass)referenceElement.resolve();
            if (aClass == null) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            String containingPackageName = file.getPackageName();
            if (!containingPackageName.equals(packageName = ClassUtil.extractPackageName((String)qualifiedName)) && importList.findSingleClassImportStatement(qualifiedName) == null) {
                if (importList.findOnDemandImportStatement(packageName) == null) {
                    UnnecessaryFullyQualifiedNameFix.addImport(importList, aClass);
                } else if (ImportUtils.hasDefaultImportConflict(qualifiedName, file)) {
                    UnnecessaryFullyQualifiedNameFix.addImport(importList, aClass);
                } else if (ImportUtils.hasOnDemandImportConflict(qualifiedName, file)) {
                    UnnecessaryFullyQualifiedNameFix.addImport(importList, aClass);
                }
            }
            String fullyQualifiedText = referenceElement.getText();
            QualificationRemover qualificationRemover = new QualificationRemover(fullyQualifiedText);
            file.accept((PsiElementVisitor)qualificationRemover);
            if (this.isOnTheFly()) {
                Collection<PsiElement> shortenedElements = qualificationRemover.getShortenedElements();
                HighlightUtils.highlightElements(shortenedElements);
                UnnecessaryFullyQualifiedNameFix.showStatusMessage(file.getProject(), shortenedElements.size());
            }
        }

        private static void showStatusMessage(Project project, int elementCount) {
            WindowManager windowManager = WindowManager.getInstance();
            StatusBar statusBar = windowManager.getStatusBar(project);
            if (elementCount == 1) {
                statusBar.setInfo(InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.status.bar.escape.highlighting.message1", new Object[0]));
            } else {
                statusBar.setInfo(InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.status.bar.escape.highlighting.message2", elementCount - 1));
            }
        }

        private static void addImport(PsiImportList importList, PsiClass aClass) throws IncorrectOperationException {
            Project project = importList.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory elementFactory = psiFacade.getElementFactory();
            PsiImportStatement importStatement = elementFactory.createImportStatement(aClass);
            importList.add((PsiElement)importStatement);
        }

        private static class QualificationRemover
        extends JavaRecursiveElementVisitor {
            private final String fullyQualifiedText;
            private final List<PsiElement> shortenedElements = new ArrayList<PsiElement>();

            QualificationRemover(String fullyQualifiedText) {
                this.fullyQualifiedText = fullyQualifiedText;
            }

            public Collection<PsiElement> getShortenedElements() {
                return Collections.unmodifiableCollection(this.shortenedElements);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class);
                if (parent != null) {
                    return;
                }
                String text = reference.getText();
                if (text.equals(this.fullyQualifiedText)) {
                    PsiElement qualifier = reference.getQualifier();
                    if (qualifier == null) {
                        return;
                    }
                    try {
                        qualifier.delete();
                    }
                    catch (IncorrectOperationException e) {
                        Class<?> aClass = ((Object)((Object)this)).getClass();
                        String className = aClass.getName();
                        Logger logger = Logger.getInstance((String)className);
                        logger.error((Throwable)e);
                    }
                    this.shortenedElements.add((PsiElement)reference);
                }
            }
        }
    }
}

