/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ImplicitCallToSuperInspection
extends BaseInspection {
    public boolean m_ignoreForObjectSubclasses = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.call.to.super.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ImplicitCallToSuperInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("implicit.call.to.super.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ImplicitCallToSuperInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddExplicitSuperCall();
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("implicit.call.to.super.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreForObjectSubclasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitCallToSuperVisitor();
    }

    private class ImplicitCallToSuperVisitor
    extends BaseInspectionVisitor {
        private ImplicitCallToSuperVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ImplicitCallToSuperInspection$ImplicitCallToSuperVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (!method.isConstructor()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            if (ImplicitCallToSuperInspection.this.m_ignoreForObjectSubclasses && (superClass = containingClass.getSuperClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                this.registerMethodError(method, new Object[0]);
                return;
            }
            PsiStatement firstStatement = statements[0];
            if (this.isConstructorCall(firstStatement)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isConstructorCall(PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String text = methodExpression.getText();
            return "super".equals(text) || "this".equals(text);
        }
    }

    private static class AddExplicitSuperCall
    extends InspectionGadgetsFix {
        private AddExplicitSuperCall() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("implicit.call.to.super.make.explicit.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ImplicitCallToSuperInspection$AddExplicitSuperCall.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiStatement newStatement = factory.createStatementFromText("super();", null);
            CodeStyleManager styleManager = psiManager.getCodeStyleManager();
            if (body == null) {
                return;
            }
            PsiJavaToken brace = body.getLBrace();
            body.addAfter((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body);
        }
    }
}

