/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInnerClassWithNonSerializableOuterClassInspection;
import org.jetbrains.annotations.NotNull;

class SerializableInnerClassWithNonSerializableOuterClassVisitor
extends BaseInspectionVisitor {
    private final SerializableInnerClassWithNonSerializableOuterClassInspection inspection;

    public SerializableInnerClassWithNonSerializableOuterClassVisitor(SerializableInnerClassWithNonSerializableOuterClassInspection inspection) {
        this.inspection = inspection;
    }

    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/SerializableInnerClassWithNonSerializableOuterClassVisitor.visitClass must not be null");
        }
        if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
            return;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (aClass.hasModifierProperty("static")) {
            return;
        }
        if (!SerializationUtils.isSerializable(aClass)) {
            return;
        }
        if (SerializationUtils.isSerializable(containingClass)) {
            return;
        }
        if (this.inspection.isIgnoredSubclass(aClass)) {
            return;
        }
        this.registerClassError(aClass, new Object[0]);
    }
}

