/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class PublicStaticCollectionFieldInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.static.collection.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/PublicStaticCollectionFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.static.collection.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/PublicStaticCollectionFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicStaticCollectionFieldVisitor();
    }

    private static class PublicStaticCollectionFieldVisitor
    extends BaseInspectionVisitor {
        private PublicStaticCollectionFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/security/PublicStaticCollectionFieldInspection$PublicStaticCollectionFieldVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (!field.hasModifierProperty("public")) {
                return;
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiType type = field.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

