/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceInspection
extends BaseInspection {
    @Nullable
    protected static PsiVariable getVariable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/ResourceInspection.getVariable must not be null");
        }
        if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null || !(referent instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)referent;
        }
        if (element instanceof PsiVariable) {
            return (PsiVariable)element;
        }
        return null;
    }

    protected static PsiElement getExpressionParent(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    protected static boolean isSafelyClosed(@Nullable PsiVariable boundVariable, PsiExpression creationContext) {
        if (boundVariable == null) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)creationContext, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (!(nextStatement instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
        return ResourceInspection.resourceIsClosedInFinally(tryStatement, boundVariable);
    }

    protected static boolean resourceIsClosedInFinally(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable boundVariable) {
        if (tryStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/ResourceInspection.resourceIsClosedInFinally must not be null");
        }
        if (boundVariable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/resources/ResourceInspection.resourceIsClosedInFinally must not be null");
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        CloseVisitor visitor = new CloseVisitor(boundVariable);
        finallyBlock.accept((PsiElementVisitor)visitor);
        return visitor.containsClose();
    }

    protected static boolean isResourceEscapedFromMethod(PsiVariable boundVariable, PsiElement context) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (method == null) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        EscapeVisitor visitor = new EscapeVisitor(boundVariable);
        body.accept((PsiElementVisitor)visitor);
        return visitor.isEscaped();
    }

    private static class EscapeVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiVariable boundVariable;
        private boolean escaped = false;

        public EscapeVisitor(PsiVariable boundVariable) {
            this.boundVariable = boundVariable;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
        }

        public void visitElement(PsiElement element) {
            if (this.escaped) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            PsiExpression value = statement.getReturnValue();
            if ((value = PsiUtil.deparenthesizeExpression((PsiExpression)value)) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)value).resolve()) == this.boundVariable) {
                this.escaped = true;
            }
        }

        public boolean isEscaped() {
            return this.escaped;
        }
    }

    private static class CloseVisitor
    extends JavaRecursiveElementVisitor {
        private boolean containsClose = false;
        private final PsiVariable resource;
        private final String resourceName;

        private CloseVisitor(PsiVariable resource) {
            this.resource = resource;
            this.resourceName = resource.getName();
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/ResourceInspection$CloseVisitor.visitElement must not be null");
            }
            if (!this.containsClose) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/ResourceInspection$CloseVisitor.visitMethodCallExpression must not be null");
            }
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call);
            if (!CloseVisitor.isResourceClose(call, this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
            PsiStatement[] statements;
            super.visitReferenceExpression(referenceExpression);
            if (this.containsClose) {
                return;
            }
            String text = referenceExpression.getText();
            if (text == null || !text.equals(this.resourceName)) {
                return;
            }
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList argumentList = (PsiExpressionList)parent;
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement target = referenceExpression.resolve();
            if (target == null || !target.equals(this.resource)) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiCodeBlock codeBlock = method.getBody();
            if (codeBlock == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length != 1) {
                return;
            }
            PsiParameter parameter = parameters[0];
            for (PsiStatement statement : statements = codeBlock.getStatements()) {
                PsiStatement[] innerStatements;
                if (!(statement instanceof PsiTryStatement)) continue;
                PsiTryStatement tryStatement = (PsiTryStatement)statement;
                PsiCodeBlock tryBlock = tryStatement.getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                for (PsiStatement innerStatement : innerStatements = tryBlock.getStatements()) {
                    PsiMethodCallExpression potentialCloseExpression;
                    PsiExpressionStatement expressionStatement;
                    PsiExpression expression;
                    if (!(innerStatement instanceof PsiExpressionStatement) || !((expression = (expressionStatement = (PsiExpressionStatement)innerStatement).getExpression()) instanceof PsiMethodCallExpression) || !CloseVisitor.isResourceClose(potentialCloseExpression = (PsiMethodCallExpression)expression, (PsiVariable)parameter)) continue;
                    this.containsClose = true;
                    return;
                }
            }
        }

        private static boolean isResourceClose(PsiMethodCallExpression call, PsiVariable resource) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"close".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReference reference = (PsiReference)qualifier;
            PsiElement referent = reference.resolve();
            return referent != null && referent.equals(resource);
        }

        public boolean containsClose() {
            return this.containsClose;
        }
    }
}

