/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinalUtils {
    private FinalUtils() {
    }

    public static boolean canFieldBeFinal(PsiField field) {
        ImplicitUsageProvider[] implicitUsageProviders;
        if (!field.hasModifierProperty("private")) {
            return false;
        }
        if (field.hasModifierProperty("final")) {
            return false;
        }
        for (ImplicitUsageProvider provider : implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
            if (!provider.isImplicitWrite((PsiElement)field)) continue;
            return false;
        }
        return !(field.hasModifierProperty("static") ? !FinalUtils.staticFieldMayBeFinal(field) : !FinalUtils.fieldMayBeFinal(field));
    }

    private static boolean fieldMayBeFinal(PsiField field) {
        PsiField[] fields;
        PsiMethod[] methods;
        boolean assignedInInitializer;
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiExpression initializer = field.getInitializer();
        PsiClassInitializer[] classInitializers = aClass.getInitializers();
        boolean isInitialized = assignedInInitializer = initializer != null;
        for (PsiClassInitializer classInitializer : classInitializers) {
            if (classInitializer.hasModifierProperty("static") || !VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)classInitializer, false)) continue;
            if (assignedInInitializer) {
                return false;
            }
            if (FinalUtils.variableIsAssignedOnceAndOnlyOnce((PsiVariable)field, (PsiElement)classInitializer)) {
                isInitialized = true;
            }
            assignedInInitializer = true;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (method.hasModifierProperty("static")) continue;
            if (method.isConstructor() && !assignedInInitializer) {
                if (!VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)method, false)) {
                    return false;
                }
                if (!FinalUtils.variableIsAssignedOnceAndOnlyOnce((PsiVariable)field, (PsiElement)method)) continue;
                isInitialized = true;
                continue;
            }
            if (!VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)method, false)) continue;
            return false;
        }
        for (PsiField aField : fields = aClass.getFields()) {
            PsiExpression expression;
            if (aField.hasModifierProperty("static") || aField.equals(field) || (expression = aField.getInitializer()) == null || !VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)expression)) continue;
            if (assignedInInitializer || isInitialized) {
                return false;
            }
            isInitialized = true;
        }
        if (!isInitialized) {
            return false;
        }
        PsiElement[] children = aClass.getChildren();
        ClassVisitor visitor = new ClassVisitor((PsiVariable)field);
        for (PsiElement child : children) {
            child.accept((PsiElementVisitor)visitor);
            if (!visitor.isVariableAssignedInClass()) continue;
            return false;
        }
        AssignmentVisitor assignmentVisitor = new AssignmentVisitor((PsiVariable)field, aClass);
        for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            containingClass.accept((PsiElementVisitor)assignmentVisitor);
            if (!assignmentVisitor.isVariableAssigned()) continue;
            return false;
        }
        return true;
    }

    private static boolean staticFieldMayBeFinal(PsiField field) {
        PsiMethod[] methods;
        PsiField[] fields;
        PsiExpression initializer = field.getInitializer();
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiClassInitializer[] classInitializers = aClass.getInitializers();
        boolean assignedInInitializer = initializer != null;
        for (PsiClassInitializer classInitializer : classInitializers) {
            if (classInitializer.hasModifierProperty("static")) {
                if (!VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)classInitializer, false)) continue;
                if (assignedInInitializer) {
                    return false;
                }
                if (!FinalUtils.variableIsAssignedOnceAndOnlyOnce((PsiVariable)field, (PsiElement)classInitializer)) continue;
                assignedInInitializer = true;
                continue;
            }
            if (!VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)classInitializer, false)) continue;
            return false;
        }
        for (PsiField aField : fields = aClass.getFields()) {
            PsiExpression expression;
            if (aField.equals(field) || (expression = aField.getInitializer()) == null || !VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)expression)) continue;
            if (!aField.hasModifierProperty("static")) {
                return false;
            }
            if (assignedInInitializer) {
                return false;
            }
            assignedInInitializer = true;
        }
        if (!assignedInInitializer) {
            return false;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (!VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)method, false)) continue;
            return false;
        }
        PsiElement[] children = aClass.getChildren();
        ClassVisitor visitor = new ClassVisitor((PsiVariable)field);
        for (PsiElement child : children) {
            child.accept((PsiElementVisitor)visitor);
            if (!visitor.isVariableAssignedInClass()) continue;
            return false;
        }
        AssignmentVisitor assignmentVisitor = new AssignmentVisitor((PsiVariable)field, aClass);
        for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            containingClass.accept((PsiElementVisitor)assignmentVisitor);
            if (!assignmentVisitor.isVariableAssigned()) continue;
            return false;
        }
        return true;
    }

    private static boolean variableIsAssignedOnceAndOnlyOnce(@NotNull PsiVariable variable, @Nullable PsiElement contenxt) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/FinalUtils.variableIsAssignedOnceAndOnlyOnce must not be null");
        }
        if (contenxt == null) {
            return false;
        }
        AssignmentCountVisitor visitor = new AssignmentCountVisitor(variable);
        contenxt.accept((PsiElementVisitor)visitor);
        int count = visitor.getAssignmentCount();
        return count == 1;
    }

    private static class AssignmentCountVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiVariable variable;
        private int assignmentCount = 0;

        public AssignmentCountVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public void visitElement(PsiElement element) {
            if (this.assignmentCount > 1) {
                return;
            }
            super.visitElement(element);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
            PsiExpression arg = assignment.getLExpression();
            if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
                ++this.assignmentCount;
            }
            super.visitAssignmentExpression(assignment);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            PsiJavaToken operationSign = expression.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (VariableAccessUtils.mayEvaluateToVariable(operand, this.variable)) {
                ++this.assignmentCount;
            }
            super.visitPrefixExpression(expression);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            PsiJavaToken operationSign = expression.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (VariableAccessUtils.mayEvaluateToVariable(operand, this.variable)) {
                ++this.assignmentCount;
            }
            super.visitPostfixExpression(expression);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            PsiStatement body = statement.getBody();
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)body)) {
                this.assignmentCount += 2;
            }
        }

        public void visitForStatement(PsiForStatement statement) {
            PsiStatement body;
            PsiStatement update;
            PsiExpression condition;
            PsiStatement initialization = statement.getInitialization();
            if (initialization != null) {
                initialization.accept((PsiElementVisitor)this);
            }
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)(condition = statement.getCondition()))) {
                this.assignmentCount += 2;
            }
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)(update = statement.getUpdate()))) {
                this.assignmentCount += 2;
            }
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)(body = statement.getBody()))) {
                this.assignmentCount += 2;
            }
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)statement)) {
                this.assignmentCount += 2;
            }
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)statement)) {
                this.assignmentCount += 2;
            }
        }

        public void visitTryStatement(PsiTryStatement statement) {
            PsiCodeBlock finallyBlock;
            int tmp = this.assignmentCount;
            PsiCodeBlock block = statement.getTryBlock();
            if (block != null) {
                block.accept((PsiElementVisitor)this);
            }
            if (this.assignmentCount < 2 && this.assignmentCount > tmp) {
                PsiCodeBlock[] blocks;
                for (PsiCodeBlock catchBlock : blocks = statement.getCatchBlocks()) {
                    if (ExceptionUtils.blockThrowsException(catchBlock)) continue;
                    this.assignmentCount += 2;
                }
            }
            if ((finallyBlock = statement.getFinallyBlock()) != null) {
                finallyBlock.accept((PsiElementVisitor)this);
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiExpression condition = statement.getCondition();
            if (condition != null) {
                condition.accept((PsiElementVisitor)this);
            }
            Project project = statement.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiConstantEvaluationHelper helper = psiFacade.getConstantEvaluationHelper();
            Object constant = helper.computeConstantExpression((PsiElement)condition);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiStatement elseBranch = statement.getElseBranch();
            if (constant == Boolean.TRUE) {
                if (thenBranch != null) {
                    AssignmentCountVisitor visitor = new AssignmentCountVisitor(this.variable);
                    thenBranch.accept((PsiElementVisitor)visitor);
                    this.assignmentCount += visitor.getAssignmentCount();
                }
            } else if (constant == Boolean.FALSE) {
                if (elseBranch != null) {
                    AssignmentCountVisitor visitor = new AssignmentCountVisitor(this.variable);
                    elseBranch.accept((PsiElementVisitor)visitor);
                    this.assignmentCount += visitor.getAssignmentCount();
                }
            } else {
                int elseAssignmentCount;
                int thenAssignmentCount;
                if (thenBranch != null) {
                    AssignmentCountVisitor visitor = new AssignmentCountVisitor(this.variable);
                    thenBranch.accept((PsiElementVisitor)visitor);
                    thenAssignmentCount = visitor.getAssignmentCount();
                } else {
                    thenAssignmentCount = 0;
                }
                if (elseBranch != null) {
                    AssignmentCountVisitor visitor = new AssignmentCountVisitor(this.variable);
                    elseBranch.accept((PsiElementVisitor)visitor);
                    elseAssignmentCount = visitor.getAssignmentCount();
                } else {
                    elseAssignmentCount = 0;
                }
                this.assignmentCount = thenAssignmentCount != elseAssignmentCount || thenAssignmentCount > 1 ? (this.assignmentCount += 2) : (this.assignmentCount += thenAssignmentCount);
            }
        }

        public int getAssignmentCount() {
            return this.assignmentCount;
        }
    }

    private static class AssignmentVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiVariable variable;
        private final PsiClass excludedClass;
        private boolean variableAssigned = false;

        AssignmentVisitor(PsiVariable variable, PsiClass excludedClass) {
            this.variable = variable;
            this.excludedClass = excludedClass;
        }

        public void visitClass(PsiClass aClass) {
            if (this.variableAssigned) {
                return;
            }
            if (aClass.equals(this.excludedClass)) {
                return;
            }
            super.visitClass(aClass);
        }

        public void visitMethod(PsiMethod method) {
            if (this.variableAssigned) {
                return;
            }
            super.visitMethod(method);
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)method)) {
                this.variableAssigned = true;
            }
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            if (this.variableAssigned) {
                return;
            }
            super.visitClassInitializer(initializer);
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)initializer)) {
                this.variableAssigned = true;
            }
        }

        public boolean isVariableAssigned() {
            return this.variableAssigned;
        }
    }

    private static class ClassVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiVariable variable;
        private boolean variableAssignedInClass = false;

        ClassVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public void visitClass(PsiClass aClass) {
            if (this.variableAssignedInClass) {
                return;
            }
            if (VariableAccessUtils.variableIsAssigned(this.variable, (PsiElement)aClass)) {
                this.variableAssignedInClass = true;
            }
        }

        public void visitElement(PsiElement element) {
            if (this.variableAssignedInClass) {
                return;
            }
            super.visitElement(element);
        }

        public boolean isVariableAssignedInClass() {
            return this.variableAssignedInClass;
        }
    }
}

