/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeUtils {
    private ExpectedTypeUtils() {
    }

    @Nullable
    public static PsiType findExpectedType(@NotNull PsiExpression expression, boolean calculateTypeForComplexReferences) {
        PsiElement context;
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils.findExpectedType must not be null");
        }
        PsiExpression wrappedExpression = expression;
        for (context = expression.getParent(); context != null && context instanceof PsiParenthesizedExpression; context = context.getParent()) {
            wrappedExpression = (PsiExpression)context;
        }
        if (context == null) {
            return null;
        }
        ExpectedTypeVisitor visitor = new ExpectedTypeVisitor(wrappedExpression, calculateTypeForComplexReferences);
        context.accept((PsiElementVisitor)visitor);
        return visitor.getExpectedType();
    }

    private static class ExpectedTypeVisitor
    extends JavaElementVisitor {
        private static final Set<IElementType> arithmeticOps = new HashSet<IElementType>(5);
        private static final Set<IElementType> comparisonOps = new HashSet<IElementType>(6);
        private static final Set<IElementType> booleanOps = new HashSet<IElementType>(5);
        private static final Set<IElementType> operatorAssignmentOps = new HashSet<IElementType>(11);
        private final PsiExpression wrappedExpression;
        private final boolean calculateTypeForComplexReferences;
        private PsiType expectedType = null;

        ExpectedTypeVisitor(PsiExpression wrappedExpression, boolean calculateTypeForComplexReferences) {
            this.wrappedExpression = wrappedExpression;
            this.calculateTypeForComplexReferences = calculateTypeForComplexReferences;
        }

        public PsiType getExpectedType() {
            return this.expectedType;
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitField must not be null");
            }
            PsiExpression initializer = field.getInitializer();
            if (this.wrappedExpression.equals(initializer)) {
                this.expectedType = field.getType();
            }
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitVariable must not be null");
            }
            this.expectedType = variable.getType();
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression initializer) {
            PsiType type = initializer.getType();
            if (!(type instanceof PsiArrayType)) {
                this.expectedType = null;
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            this.expectedType = arrayType.getComponentType();
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression accessExpression) {
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            if (this.wrappedExpression.equals(indexExpression)) {
                this.expectedType = PsiType.INT;
            }
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression binaryExpression) {
            if (binaryExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitBinaryExpression must not be null");
            }
            PsiJavaToken sign = binaryExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            PsiType type = binaryExpression.getType();
            if (TypeUtils.isJavaLangString(type)) {
                this.expectedType = null;
            } else if (ExpectedTypeVisitor.isArithmeticOperation(tokenType)) {
                this.expectedType = type;
            } else if (ComparisonUtils.isComparisonOperation(tokenType)) {
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiType lhsType = lhs.getType();
                if (ClassUtils.isPrimitive(lhsType)) {
                    this.expectedType = lhsType;
                    return;
                }
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    this.expectedType = null;
                    return;
                }
                PsiType rhsType = rhs.getType();
                if (ClassUtils.isPrimitive(rhsType)) {
                    this.expectedType = rhsType;
                    return;
                }
                this.expectedType = null;
            } else {
                this.expectedType = ExpectedTypeVisitor.isBooleanOperation(tokenType) ? type : null;
            }
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitPrefixExpression must not be null");
            }
            PsiType type = expression.getType();
            this.expectedType = type instanceof PsiPrimitiveType ? type : PsiPrimitiveType.getUnboxedType((PsiType)type);
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitPostfixExpression must not be null");
            }
            PsiType type = expression.getType();
            this.expectedType = type instanceof PsiPrimitiveType ? type : PsiPrimitiveType.getUnboxedType((PsiType)type);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitWhileStatement must not be null");
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitForStatement must not be null");
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitIfStatement must not be null");
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitDoWhileStatement must not be null");
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitSynchronizedStatement must not be null");
            }
            PsiManager manager = statement.getManager();
            Project project = manager.getProject();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            this.expectedType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitAssignmentExpression must not be null");
            }
            PsiExpression rExpression = assignment.getRExpression();
            PsiJavaToken operationSign = assignment.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            PsiExpression lExpression = assignment.getLExpression();
            PsiType lType = lExpression.getType();
            this.expectedType = rExpression != null && this.wrappedExpression.equals(rExpression) ? (lType == null ? null : (TypeUtils.isJavaLangString(lType) ? (JavaTokenType.PLUSEQ.equals(tokenType) ? rExpression.getType() : lType) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) ? (lType instanceof PsiPrimitiveType ? lType : PsiPrimitiveType.getUnboxedType((PsiType)lType)) : lType))) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) && !(lType instanceof PsiPrimitiveType) ? PsiPrimitiveType.getUnboxedType((PsiType)lType) : lType);
        }

        public void visitConditionalExpression(PsiConditionalExpression conditional) {
            PsiExpression condition = conditional.getCondition();
            this.expectedType = condition.equals(this.wrappedExpression) ? PsiType.BOOLEAN : conditional.getType();
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitReturnStatement must not be null");
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, PsiMethod.class);
            this.expectedType = method == null ? null : method.getReturnType();
        }

        public void visitDeclarationStatement(PsiDeclarationStatement declaration) {
            PsiElement[] declaredElements;
            for (PsiElement declaredElement : declaredElements = declaration.getDeclaredElements()) {
                PsiVariable variable;
                PsiExpression initializer;
                if (!(declaredElement instanceof PsiVariable) || !this.wrappedExpression.equals(initializer = (variable = (PsiVariable)declaredElement).getInitializer())) continue;
                this.expectedType = variable.getType();
                return;
            }
        }

        public void visitExpressionList(PsiExpressionList expressionList) {
            JavaResolveResult result = ExpectedTypeVisitor.findCalledMethod(expressionList);
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                this.expectedType = null;
            } else {
                int parameterPosition = ExpectedTypeVisitor.getParameterPosition(expressionList, this.wrappedExpression);
                this.expectedType = ExpectedTypeVisitor.getTypeOfParameter(result, parameterPosition);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        private static JavaResolveResult findCalledMethod(PsiExpressionList expressionList) {
            PsiElement grandParent;
            JavaResolveResult javaResolveResult;
            PsiElement parent = expressionList.getParent();
            if (parent instanceof PsiCallExpression) {
                PsiCallExpression call = (PsiCallExpression)parent;
                javaResolveResult = call.resolveMethodGenerics();
                if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.findCalledMethod must not return null");
                return javaResolveResult;
            }
            if (parent instanceof PsiAnonymousClass && (grandParent = parent.getParent()) instanceof PsiCallExpression) {
                PsiCallExpression callExpression = (PsiCallExpression)grandParent;
                javaResolveResult = callExpression.resolveMethodGenerics();
                if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.findCalledMethod must not return null");
                return javaResolveResult;
            }
            javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult != null) return javaResolveResult;
            throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.findCalledMethod must not return null");
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.visitReferenceExpression must not be null");
            }
            if (this.calculateTypeForComplexReferences) {
                Project project = referenceExpression.getProject();
                JavaResolveResult resolveResult = referenceExpression.advancedResolve(false);
                PsiElement element = resolveResult.getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    if (!ExpectedTypeVisitor.isAccessibleFrom((PsiMember)field, (PsiElement)referenceExpression)) {
                        return;
                    }
                    PsiClass aClass = field.getContainingClass();
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else if (element instanceof PsiMethod) {
                    PsiClass aClass;
                    PsiMethod method = (PsiMethod)element;
                    PsiMethod superMethod = ExpectedTypeVisitor.findDeepestVisibleSuperMethod(method, (PsiElement)referenceExpression);
                    if (superMethod != null) {
                        aClass = superMethod.getContainingClass();
                        substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superMethod.getContainingClass(), (PsiClass)method.getContainingClass(), (PsiSubstitutor)substitutor);
                    } else {
                        aClass = method.getContainingClass();
                    }
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else {
                    this.expectedType = null;
                }
            }
        }

        @Nullable
        private static PsiMethod findDeepestVisibleSuperMethod(PsiMethod method, PsiElement element) {
            if (method.isConstructor()) {
                return null;
            }
            if (method.hasModifierProperty("static")) {
                return null;
            }
            if (method.hasModifierProperty("private")) {
                return null;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiMethod[] allMethods = aClass.getAllMethods();
            PsiMethod topSuper = null;
            for (PsiMethod superMethod : allMethods) {
                boolean looksLikeSuperMethod;
                PsiClass superClass = superMethod.getContainingClass();
                if (!ExpectedTypeVisitor.isAccessibleFrom((PsiMember)superMethod, element) || aClass.equals(superClass)) continue;
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                if (superClassSubstitutor == null) {
                    superClassSubstitutor = PsiSubstitutor.EMPTY;
                }
                String name = method.getName();
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                boolean bl = looksLikeSuperMethod = name.equals(superMethod.getName()) && !superMethod.hasModifierProperty("static") && PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)aClass, (PsiClass)aClass) && signature.equals(superMethod.getSignature(superClassSubstitutor));
                if (!looksLikeSuperMethod || topSuper != null && superClass.isInheritor(topSuper.getContainingClass(), true)) continue;
                topSuper = superMethod;
            }
            return topSuper;
        }

        private static boolean isAccessibleFrom(PsiMember member, PsiElement referencingLocation) {
            if (member.hasModifierProperty("public")) {
                return true;
            }
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiClass referencingClass = ClassUtils.getContainingClass(referencingLocation);
            if (referencingClass == null) {
                return false;
            }
            if (referencingClass.equals(containingClass)) {
                return true;
            }
            if (member.hasModifierProperty("private")) {
                return false;
            }
            return ClassUtils.inSamePackage((PsiElement)containingClass, referencingLocation);
        }

        private static boolean isArithmeticOperation(@NotNull IElementType sign) {
            if (sign == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.isArithmeticOperation must not be null");
            }
            return arithmeticOps.contains(sign);
        }

        private static boolean isBooleanOperation(@NotNull IElementType sign) {
            if (sign == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.isBooleanOperation must not be null");
            }
            return booleanOps.contains(sign);
        }

        private static boolean isOperatorAssignmentOperation(@NotNull IElementType sign) {
            if (sign == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.isOperatorAssignmentOperation must not be null");
            }
            return operatorAssignmentOps.contains(sign);
        }

        private static int getParameterPosition(@NotNull PsiExpressionList expressionList, PsiExpression expression) {
            if (expressionList == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.getParameterPosition must not be null");
            }
            PsiExpression[] expressions = expressionList.getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                if (!expressions[i].equals(expression)) continue;
                return i;
            }
            return -1;
        }

        @Nullable
        private static PsiType getTypeOfParameter(@NotNull JavaResolveResult result, int parameterPosition) {
            if (result == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor.getTypeOfParameter must not be null");
            }
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                return null;
            }
            PsiSubstitutor substitutor = result.getSubstitutor();
            PsiParameterList parameterList = method.getParameterList();
            if (parameterPosition < 0) {
                return null;
            }
            int parametersCount = parameterList.getParametersCount();
            if (parameterPosition >= parametersCount) {
                int lastParameterPosition = parametersCount - 1;
                if (lastParameterPosition < 0) {
                    return null;
                }
                PsiParameter[] parameters = parameterList.getParameters();
                PsiParameter lastParameter = parameters[lastParameterPosition];
                if (lastParameter.isVarArgs()) {
                    PsiArrayType arrayType = (PsiArrayType)lastParameter.getType();
                    return substitutor.substitute(arrayType.getComponentType());
                }
                return null;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[parameterPosition];
            PsiType parameterType = parameter.getType();
            if (parameter.isVarArgs()) {
                PsiArrayType arrayType = (PsiArrayType)parameterType;
                return substitutor.substitute(arrayType.getComponentType());
            }
            PsiType type = substitutor.substitute(parameterType);
            TypeStringCreator typeStringCreator = new TypeStringCreator();
            type.accept((PsiTypeVisitor)typeStringCreator);
            if (typeStringCreator.isModified()) {
                PsiManager manager = method.getManager();
                Project project = manager.getProject();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                try {
                    String typeString = typeStringCreator.getTypeString();
                    return factory.createTypeFromText(typeString, (PsiElement)method);
                }
                catch (IncorrectOperationException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return type;
        }

        static {
            arithmeticOps.add(JavaTokenType.PLUS);
            arithmeticOps.add(JavaTokenType.MINUS);
            arithmeticOps.add(JavaTokenType.ASTERISK);
            arithmeticOps.add(JavaTokenType.DIV);
            arithmeticOps.add(JavaTokenType.PERC);
            comparisonOps.add(JavaTokenType.EQEQ);
            comparisonOps.add(JavaTokenType.NE);
            comparisonOps.add(JavaTokenType.LE);
            comparisonOps.add(JavaTokenType.LT);
            comparisonOps.add(JavaTokenType.GE);
            comparisonOps.add(JavaTokenType.GT);
            booleanOps.add(JavaTokenType.ANDAND);
            booleanOps.add(JavaTokenType.AND);
            booleanOps.add(JavaTokenType.XOR);
            booleanOps.add(JavaTokenType.OROR);
            booleanOps.add(JavaTokenType.OR);
            operatorAssignmentOps.add(JavaTokenType.PLUSEQ);
            operatorAssignmentOps.add(JavaTokenType.MINUSEQ);
            operatorAssignmentOps.add(JavaTokenType.ASTERISKEQ);
            operatorAssignmentOps.add(JavaTokenType.DIVEQ);
            operatorAssignmentOps.add(JavaTokenType.ANDEQ);
            operatorAssignmentOps.add(JavaTokenType.OREQ);
            operatorAssignmentOps.add(JavaTokenType.XOREQ);
            operatorAssignmentOps.add(JavaTokenType.PERCEQ);
            operatorAssignmentOps.add(JavaTokenType.LTLTEQ);
            operatorAssignmentOps.add(JavaTokenType.GTGTEQ);
            operatorAssignmentOps.add(JavaTokenType.GTGTGTEQ);
        }

        private static class TypeStringCreator
        extends PsiTypeVisitor<Object> {
            private final StringBuilder typeString = new StringBuilder();
            private boolean modified = false;

            private TypeStringCreator() {
            }

            public Object visitType(PsiType type) {
                this.typeString.append(type.getCanonicalText());
                return super.visitType(type);
            }

            public Object visitWildcardType(PsiWildcardType wildcardType) {
                PsiClassType classType;
                PsiClass aClass;
                PsiType extendsBound;
                if (wildcardType.isExtends() && (extendsBound = wildcardType.getExtendsBound()) instanceof PsiClassType && (aClass = (classType = (PsiClassType)extendsBound).resolve()) != null && aClass.hasModifierProperty("final")) {
                    this.modified = true;
                    return super.visitClassType(classType);
                }
                return super.visitWildcardType(wildcardType);
            }

            public Object visitClassType(PsiClassType classType) {
                PsiClassType rawType = classType.rawType();
                this.typeString.append(rawType.getCanonicalText());
                PsiType[] parameterTypes = classType.getParameters();
                if (parameterTypes.length > 0) {
                    this.typeString.append('<');
                    PsiType parameterType1 = parameterTypes[0];
                    if (parameterType1 != null) {
                        parameterType1.accept((PsiTypeVisitor)this);
                    }
                    for (int i = 1; i < parameterTypes.length; ++i) {
                        this.typeString.append(',');
                        PsiType parameterType = parameterTypes[i];
                        if (parameterType == null) continue;
                        parameterType.accept((PsiTypeVisitor)this);
                    }
                    this.typeString.append('>');
                }
                return null;
            }

            public String getTypeString() {
                return this.typeString.toString();
            }

            public boolean isModified() {
                return this.modified;
            }
        }
    }
}

