/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VariableAccessVisitor
extends JavaRecursiveElementVisitor {
    private final Map<PsiField, Integer> m_accessCounts = new HashMap<PsiField, Integer>(2);
    private final Set<PsiField> m_overAccessedFields = new HashSet<PsiField>(2);

    public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
        Map<PsiField, Integer> accessCounts;
        Integer count;
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/VariableAccessVisitor.visitReferenceExpression must not be null");
        }
        super.visitReferenceExpression(ref);
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return;
        }
        PsiElement element = ref.resolve();
        if (!(element instanceof PsiField)) {
            return;
        }
        Set<PsiField> overAccessedFields = this.m_overAccessedFields;
        PsiField field = (PsiField)element;
        if (overAccessedFields.contains(field)) {
            return;
        }
        if (ControlFlowUtils.isInLoop((PsiElement)field)) {
            overAccessedFields.add(field);
        }
        if ((count = (accessCounts = this.m_accessCounts).get(field)) == null) {
            accessCounts.put(field, 1);
        } else if (count == 1) {
            accessCounts.put(field, 2);
        } else {
            overAccessedFields.add(field);
        }
    }

    public Set<PsiField> getOveraccessedFields() {
        return Collections.unmodifiableSet(this.m_overAccessedFields);
    }
}

