/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StringBufferReplaceableByStringBuilderInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("StringBufferMayBeStringBuilder" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferReplaceableByStringBuilderInspection.getID must not return null");
        }
        return "StringBufferMayBeStringBuilder";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferReplaceableByStringBuilderInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferReplaceableByStringBuilderInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringBufferMayBeStringBuilderFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringBuilderVisitor();
    }

    private static class StringBufferReplaceableByStringBuilderVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> excludes = new HashSet<String>(Arrays.asList("java.lang.StringBuilder", "java.lang.StringBuffer"));

        private StringBufferReplaceableByStringBuilderVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringBufferReplaceableByStringBuilderInspection$StringBufferReplaceableByStringBuilderVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)variable)) {
                return;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return;
            }
            PsiType type = variable.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type)) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            if (!StringBufferReplaceableByStringBuilderVisitor.isNewStringBuffer(initializer)) {
                return;
            }
            if (VariableAccessUtils.variableIsAssigned((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            if (VariableAccessUtils.variableIsAssignedFrom((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            if (VariableAccessUtils.variableIsReturned((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument((PsiVariable)variable, excludes, (PsiElement)codeBlock)) {
                return;
            }
            if (VariableAccessUtils.variableIsUsedInInnerClass((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, new Object[0]);
        }

        private static boolean isNewStringBuffer(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PsiNewExpression) {
                return true;
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"append".equals(methodName)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                return StringBufferReplaceableByStringBuilderVisitor.isNewStringBuffer(qualifier);
            }
            return false;
        }
    }

    private static class StringBufferMayBeStringBuilderFix
    extends InspectionGadgetsFix {
        private StringBufferMayBeStringBuilderFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferReplaceableByStringBuilderInspection$StringBufferMayBeStringBuilderFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement variableIdentifier = descriptor.getPsiElement();
            PsiLocalVariable variable = (PsiLocalVariable)variableIdentifier.getParent();
            assert (variable != null);
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)variable.getParent();
            String text = declarationStatement.getText();
            String newStatement = text.replaceAll("StringBuffer", "StringBuilder");
            StringBufferMayBeStringBuilderFix.replaceStatement((PsiStatement)declarationStatement, newStatement);
        }
    }
}

