/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class DivideByZeroInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("divzero" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/DivideByZeroInspection.getID must not return null");
        }
        return "divzero";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("divide.by.zero.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/DivideByZeroInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("divide.by.zero.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/DivideByZeroInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private static class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/DivideByZeroInspection$DivisionByZeroVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.DIV) && !tokenType.equals(JavaTokenType.PERC)) {
                return;
            }
            Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)rhs, (PsiType)PsiType.DOUBLE);
            if (value == null || !(value instanceof Double)) {
                return;
            }
            double constantValue = (Double)value;
            if (constantValue == 0.0 || constantValue == -0.0) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            PsiExpression rhs = expression.getRExpression();
            if (rhs == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.DIVEQ) && !tokenType.equals(JavaTokenType.PERCEQ)) {
                return;
            }
            Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)rhs, (PsiType)PsiType.DOUBLE);
            if (value == null || !(value instanceof Double)) {
                return;
            }
            double constantValue = (Double)value;
            if (constantValue == 0.0 || constantValue == -0.0) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }
    }
}

