/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.ui.CheckBox;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LocalVariableNamingConventionInspection
extends ConventionInspection {
    public boolean m_ignoreForLoopParameters = false;
    public boolean m_ignoreCatchParameters = false;
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("local.variable.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/LocalVariableNamingConventionInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        String varName = (String)infos[0];
        if (varName.length() < this.getMinLength()) {
            string = InspectionGadgetsBundle.message("local.variable.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/LocalVariableNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        if (varName.length() > this.getMaxLength()) {
            string = InspectionGadgetsBundle.message("local.variable.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/LocalVariableNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("local.variable.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/LocalVariableNamingConventionInspection.buildErrorString must not return null");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    @Override
    public Collection<? extends JComponent> createExtraOptions() {
        return Arrays.asList(new CheckBox(InspectionGadgetsBundle.message("local.variable.naming.convention.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreForLoopParameters"), new CheckBox(InspectionGadgetsBundle.message("local.variable.naming.convention.ignore.catch.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreCatchParameters"));
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiForStatement forLoop;
            PsiStatement initialization;
            PsiElement grandparent;
            PsiElement parent;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/LocalVariableNamingConventionInspection$NamingConventionsVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            if (LocalVariableNamingConventionInspection.this.m_ignoreForLoopParameters && (parent = variable.getParent()) != null && (grandparent = parent.getParent()) instanceof PsiForStatement && parent.equals(initialization = (forLoop = (PsiForStatement)grandparent).getInitialization())) {
                return;
            }
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (LocalVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name);
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/LocalVariableNamingConventionInspection$NamingConventionsVisitor.visitParameter must not be null");
            }
            PsiElement scope = variable.getDeclarationScope();
            boolean isCatchParameter = scope instanceof PsiCatchSection;
            boolean isForeachParameter = scope instanceof PsiForeachStatement;
            if (!isCatchParameter && !isForeachParameter) {
                return;
            }
            if (LocalVariableNamingConventionInspection.this.m_ignoreCatchParameters && isCatchParameter) {
                return;
            }
            if (LocalVariableNamingConventionInspection.this.m_ignoreForLoopParameters && isForeachParameter) {
                return;
            }
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (LocalVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name);
        }
    }
}

