/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JavaRecursiveElementVisitor {
    private int m_count = 0;

    NegationCountVisitor() {
    }

    public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/NegationCountVisitor.visitBinaryExpression must not be null");
        }
        super.visitBinaryExpression(expression);
        PsiJavaToken sign = expression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (tokenType.equals(JavaTokenType.NE)) {
            ++this.m_count;
        }
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/NegationCountVisitor.visitAnonymousClass must not be null");
        }
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/NegationCountVisitor.visitPrefixExpression must not be null");
        }
        super.visitPrefixExpression(expression);
        PsiJavaToken sign = expression.getOperationSign();
        if (sign.getTokenType().equals(JavaTokenType.EXCL)) {
            ++this.m_count;
        }
    }

    public int getCount() {
        return this.m_count;
    }
}

