/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import org.jetbrains.annotations.NotNull;

class CallToSuperTeardownVisitor
extends JavaRecursiveElementVisitor {
    private boolean callToSuperTearDownFound = false;

    CallToSuperTeardownVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/CallToSuperTeardownVisitor.visitElement must not be null");
        }
        if (!this.callToSuperTearDownFound) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/CallToSuperTeardownVisitor.visitMethodCallExpression must not be null");
        }
        if (this.callToSuperTearDownFound) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"tearDown".equals(methodName)) {
            return;
        }
        PsiExpression target = methodExpression.getQualifierExpression();
        if (!(target instanceof PsiSuperExpression)) {
            return;
        }
        this.callToSuperTearDownFound = true;
    }

    public boolean isCallToSuperTeardownFound() {
        return this.callToSuperTearDownFound;
    }
}

