/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import org.jetbrains.annotations.NotNull;

class CallToSuperFinalizeVisitor
extends JavaRecursiveElementVisitor {
    private boolean callToSuperFinalizeFound = false;

    CallToSuperFinalizeVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/finalization/CallToSuperFinalizeVisitor.visitElement must not be null");
        }
        if (!this.callToSuperFinalizeFound) {
            super.visitElement(element);
        }
    }

    public void visitIfStatement(PsiIfStatement statement) {
        PsiExpression condition = statement.getCondition();
        Project project = statement.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        Object result = constantEvaluationHelper.computeConstantExpression((PsiElement)condition);
        if (result != null && result.equals(Boolean.FALSE)) {
            return;
        }
        super.visitIfStatement(statement);
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/finalization/CallToSuperFinalizeVisitor.visitMethodCallExpression must not be null");
        }
        if (this.callToSuperFinalizeFound) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression target = methodExpression.getQualifierExpression();
        if (!(target instanceof PsiSuperExpression)) {
            return;
        }
        String methodName = methodExpression.getReferenceName();
        if (!"finalize".equals(methodName)) {
            return;
        }
        this.callToSuperFinalizeFound = true;
    }

    public boolean isCallToSuperFinalizeFound() {
        return this.callToSuperFinalizeFound;
    }
}

