/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadDeathRethrownInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ThreadDeathNotRethrown" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ThreadDeathRethrownInspection.getID must not return null");
        }
        return "ThreadDeathNotRethrown";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.death.rethrown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ThreadDeathRethrownInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.death.rethrown.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ThreadDeathRethrownInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadDeathRethrownVisitor();
    }

    private static class ThreadDeathRethrownVisitor
    extends BaseInspectionVisitor {
        private ThreadDeathRethrownVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/ThreadDeathRethrownInspection$ThreadDeathRethrownVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                PsiParameter parameter = catchSection.getParameter();
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (parameter == null || catchBlock == null) continue;
                this.checkCatchBlock(parameter, catchBlock);
            }
        }

        private void checkCatchBlock(PsiParameter parameter, PsiCodeBlock catchBlock) {
            PsiType type = parameter.getType();
            if (!TypeUtils.typeEquals("java.lang.ThreadDeath", type)) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            PsiStatement[] statements = catchBlock.getStatements();
            if (statements.length == 0) {
                this.registerError((PsiElement)typeElement, new Object[0]);
                return;
            }
            PsiStatement lastStatement = statements[statements.length - 1];
            if (!(lastStatement instanceof PsiThrowStatement)) {
                this.registerError((PsiElement)typeElement, new Object[0]);
                return;
            }
            PsiThrowStatement throwStatement = (PsiThrowStatement)lastStatement;
            PsiExpression exception = throwStatement.getException();
            if (!(exception instanceof PsiReferenceExpression)) {
                this.registerError((PsiElement)typeElement, new Object[0]);
                return;
            }
            PsiElement element = ((PsiReference)exception).resolve();
            if (parameter.equals(element)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }
    }
}

