/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class LoopStatementsThatDontLoopInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("LoopStatementThatDoesntLoop" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection.getID must not return null");
        }
        return "LoopStatementThatDoesntLoop";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.statements.that.dont.loop.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("loop.statements.that.dont.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopStatementsThatDontLoopVisitor();
    }

    private static class LoopStatementsThatDontLoopVisitor
    extends BaseInspectionVisitor {
        private LoopStatementsThatDontLoopVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor.visitForeachStatement must not be null");
            }
            super.visitForeachStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor.visitWhileStatement must not be null");
            }
            super.visitWhileStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor.visitDoWhileStatement must not be null");
            }
            super.visitDoWhileStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

