/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfStatementWithIdenticalBranchesInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseIfFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithIdenticalBranchesVisitor();
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$IfStatementWithIdenticalBranchesVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(ifStatement);
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (thenBranch == null) {
                return;
            }
            if (elseBranch == null) {
                this.checkIfStatementWithoutElseBranch(ifStatement);
            } else if (EquivalenceChecker.statementsAreEquivalent(thenBranch, elseBranch)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
            }
        }

        private void checkIfStatementWithoutElseBranch(PsiIfStatement ifStatement) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            PsiStatement nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement((PsiStatement)ifStatement);
            if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                PsiStatement lastStatement = statements[statements.length - 1];
                for (PsiStatement statement : statements) {
                    if (nextStatement == null) {
                        PsiReturnStatement returnStatement;
                        if (statement == lastStatement && statement instanceof PsiReturnStatement && (returnStatement = (PsiReturnStatement)statement).getReturnValue() == null) {
                            this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
                        }
                        return;
                    }
                    if (!EquivalenceChecker.statementsAreEquivalent(statement, nextStatement)) {
                        return;
                    }
                    nextStatement = IfStatementWithIdenticalBranchesVisitor.getNextStatement(nextStatement);
                }
            } else if (!EquivalenceChecker.statementsAreEquivalent(thenBranch, nextStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
        }

        @Nullable
        private static PsiStatement getNextStatement(PsiStatement statement) {
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (nextStatement == null) {
                PsiElement nextStatementParent;
                PsiElement statementParent;
                if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiStatement.class)) == null) {
                    return null;
                }
                if (statement instanceof PsiLoopStatement) {
                    return statement;
                }
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
                if (nextStatement == null || !((statementParent = statement.getParent()) instanceof PsiIfStatement) || !statementParent.equals(nextStatementParent = nextStatement.getParent())) continue;
                nextStatement = null;
            }
            return nextStatement;
        }
    }

    private static class CollapseIfFix
    extends InspectionGadgetsFix {
        private CollapseIfFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("if.statement.with.identical.branches.collapse.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CollapseIfFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CollapseIfFix.doFix must not be null");
            }
            PsiElement identifier = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)identifier.getParent();
            assert (statement != null);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                statement.delete();
                return;
            }
            PsiElement parent = statement.getParent();
            if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                if (parent instanceof PsiCodeBlock) {
                    PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                    PsiStatement[] statements = codeBlock.getStatements();
                    if (statements.length > 0) {
                        parent.addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)statement);
                    }
                    statement.delete();
                } else {
                    statement.replace((PsiElement)blockStatement);
                }
            } else {
                statement.replace((PsiElement)thenBranch);
            }
        }
    }
}

